/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.counters;

import com.mcwfurnitures.kikoz.objects.counters.Counter;
import com.mcwfurnitures.kikoz.storage.StorageTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CupboardCounter
extends Counter
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;

    public CupboardCounter(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StorageTileEntity(pos, state);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(HINGE, (Comparable)this.getHinge(context))).m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item != this.m_5456_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof StorageTileEntity) {
                StorageTileEntity blockEntity2 = (StorageTileEntity)blockEntity;
                player.m_5893_((MenuProvider)blockEntity2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!state.m_60713_(statetwo.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockentity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, statetwo, bool);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof StorageTileEntity) {
            ((StorageTileEntity)blockentity).recheckOpen();
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livent, ItemStack stack) {
        BlockEntity blockentity;
        if (stack.m_41788_() && (blockentity = level.m_7702_(pos)) instanceof StorageTileEntity) {
            ((StorageTileEntity)blockentity).m_58638_(stack.m_41786_());
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        int j = direction.m_122429_();
        int k = direction.m_122431_();
        Vec3 vector3d = context.m_43720_();
        double d0 = vector3d.f_82479_ - (double)blockpos.m_123341_();
        double d1 = vector3d.f_82481_ - (double)blockpos.m_123343_();
        return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HINGE});
    }
}

