/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.index;

import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.mrh0.createaddition.recipe.charging.ChargingRecipeSerializer;
import com.mrh0.createaddition.recipe.conditions.HasFluidTagCondition;
import com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipe;
import com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipeSerializer;
import com.mrh0.createaddition.recipe.rolling.RollingRecipe;
import com.mrh0.createaddition.recipe.rolling.RollingRecipeProcessingFactory;
import com.mrh0.createaddition.recipe.rolling.SequencedAssemblyRollingRecipeSerializer;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CARecipes {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"createaddition");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"createaddition");
    public static final Supplier<RecipeType<RollingRecipe>> ROLLING_TYPE = CARecipes.register("rolling");
    static RegistryObject<RecipeSerializer<?>> ROLLING = SERIALIZERS.register("rolling", () -> new SequencedAssemblyRollingRecipeSerializer(new RollingRecipeProcessingFactory()));
    public static final Supplier<RecipeType<ChargingRecipe>> CHARGING_TYPE = CARecipes.register("charging");
    static RegistryObject<RecipeSerializer<?>> CHARGING = SERIALIZERS.register("charging", () -> new ChargingRecipeSerializer());
    public static final Supplier<RecipeType<LiquidBurningRecipe>> LIQUID_BURNING_TYPE = CARecipes.register("liquid_burning");
    static RegistryObject<RecipeSerializer<?>> LIQUID_BURNING = SERIALIZERS.register("liquid_burning", () -> new LiquidBurningRecipeSerializer());

    private static <T extends Recipe<?>> Supplier<RecipeType<T>> register(final String id) {
        return RECIPE_TYPES.register(id, () -> new RecipeType<T>(){

            public String toString() {
                return id;
            }
        });
    }

    public static void register(IEventBus event) {
        SERIALIZERS.register(event);
        RECIPE_TYPES.register(event);
        CraftingHelper.register((IConditionSerializer)HasFluidTagCondition.Serializer.INSTANCE);
    }
}

