/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data;

import com.railwayteam.railways.base.data.forge.BuilderTransformersImpl;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBarsBlock;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.base.CRBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.AbstractMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyBlock;
import com.railwayteam.railways.content.custom_tracks.generic_crossing.GenericCrossingBlock;
import com.railwayteam.railways.content.handcar.HandcarBlock;
import com.railwayteam.railways.content.palettes.boiler.BoilerBlock;
import com.railwayteam.railways.content.palettes.boiler.BoilerGenerator;
import com.railwayteam.railways.content.palettes.smokebox.PalettesSmokeboxBlock;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRPalettes;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.ColorUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;

public class BuilderTransformers {
    public static <B extends MonoBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> monobogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/monorail/top" + ((Boolean)s.m_61143_((Property)AbstractMonoBogeyBlock.UPSIDE_DOWN) != false ? "_upside_down" : ""))))).loot((p, l) -> p.m_124147_((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static <B extends InvisibleBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> invisibleBogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/invisible/top")))).loot((p, l) -> p.m_124147_((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static <B extends InvisibleMonoBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> invisibleMonoBogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/invisible_monorail/top" + ((Boolean)s.m_61143_((Property)AbstractMonoBogeyBlock.UPSIDE_DOWN) != false ? "_upside_down" : ""))))).loot((p, l) -> p.m_124147_((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    private static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> sharedBogey() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(BlockBehaviour.Properties::m_60955_).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).loot((p, l) -> p.m_124147_((Block)l, (ItemLike)AllBlocks.RAILWAY_CASING.get()));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> standardBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/top"))));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> wideBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/wide/top"))));
    }

    public static <B extends CRBogeyBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> narrowBogey() {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.sharedBogey())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc("block/bogey/narrow/top"))));
    }

    public static <B extends HandcarBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> handcar() {
        return b -> ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_56725_).m_60955_()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.mcLoc("air")))).loot((p, l) -> p.m_124147_((Block)l, (ItemLike)CRBlocks.HANDCAR.get()));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <B extends GenericCrossingBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> genericCrossing() {
        return BuilderTransformersImpl.genericCrossing();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> locoMetalBase(@Nullable DyeColor color, @Nullable String type) {
        return b -> {
            BlockBuilder out = ((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_155949_(ColorUtils.materialColorFromDye(color, MaterialColor.f_76365_)).m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{AllTags.AllBlockTags.WRENCH_PICKUP.tag}).tag(new TagKey[]{CRTags.AllBlockTags.LOCOMETAL.tag});
            if (type != null) {
                out = out.blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().cubeAll(c.getName(), p.modLoc("block/palettes/" + BuilderTransformers.colorName(color) + "/" + type))));
            }
            return out;
        };
    }

    public static <B extends RotatedPillarBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> locoMetalPillar(@Nullable DyeColor color) {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.locoMetalBase(color, null))).blockstate((c, p) -> p.axisBlock((RotatedPillarBlock)c.get(), p.modLoc("block/palettes/" + BuilderTransformers.colorName(color) + "/riveted_pillar_side"), p.modLoc("block/palettes/" + BuilderTransformers.colorName(color) + "/riveted_pillar_top")));
    }

    public static <B extends PalettesSmokeboxBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> locoMetalSmokeBox(@Nullable DyeColor color) {
        return b -> ((BlockBuilder)b.transform(BuilderTransformers.locoMetalBase(color, null))).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            String name = dir.m_122434_().m_122478_() ? "smokebox" : "smokebox_horizontal";
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(BuilderTransformers.colorNameUnderscore(color) + "locometal_" + name, p.modLoc("block/palettes/smokebox/" + name))).texture("side", p.modLoc("block/palettes/" + BuilderTransformers.colorName(color) + "/tank_side"))).texture("top", p.modLoc("block/palettes/" + BuilderTransformers.colorName(color) + "/smokebox_tank_top"))).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
        }));
    }

    public static <B extends BoilerBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> locoMetalBoiler(@Nullable DyeColor color, @Nullable CRPalettes.Wrapping wrapping) {
        return b -> ((BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::softMetal).properties(p -> p.m_155949_(ColorUtils.materialColorFromDye(color, MaterialColor.f_76365_)).m_60918_(SoundType.f_56725_).m_60955_()).tag(new TagKey[]{CRTags.AllBlockTags.LOCOMETAL.tag}).tag(new TagKey[]{CRTags.AllBlockTags.LOCOMETAL_BOILERS.tag}).tag(new TagKey[]{AllTags.AllBlockTags.COPYCAT_DENY.tag}).transform(TagGen.pickaxeOnly())).onRegisterAfter(Registry.f_122904_, v -> ItemDescription.useKey((ItemLike)v, (String)"block.railways.boiler"))).blockstate((arg_0, arg_1) -> ((BoilerGenerator)new BoilerGenerator(color, wrapping)).generate(arg_0, arg_1));
    }

    private static String colorName(@Nullable DyeColor color) {
        return color == null ? "netherite" : color.name().toLowerCase(Locale.ROOT);
    }

    private static String colorNameUnderscore(@Nullable DyeColor color) {
        return color == null ? "" : color.name().toLowerCase(Locale.ROOT) + "_";
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> variantBuffer() {
        return BuilderTransformersImpl.variantBuffer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <I extends Item, P> NonNullUnaryOperator<ItemBuilder<I, P>> variantBufferItem() {
        return BuilderTransformersImpl.variantBufferItem();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <B extends CopycatHeadstockBarsBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> copycatHeadstockBars() {
        return BuilderTransformersImpl.copycatHeadstockBars();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <B extends CopycatHeadstockBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> copycatHeadstock() {
        return BuilderTransformersImpl.copycatHeadstock();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <I extends Item, P> NonNullUnaryOperator<ItemBuilder<I, P>> copycatHeadstockItem() {
        return BuilderTransformersImpl.copycatHeadstockItem();
    }
}

