/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.content.buffer.BufferBlockPlaceContext;
import com.railwayteam.railways.content.buffer.NarrowTrackBufferBlock;
import com.railwayteam.railways.content.buffer.TrackBufferBlockEntity;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.util.AdventureUtils;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class TrackBufferBlock<BE extends TrackBufferBlockEntity>
extends HorizontalDirectionalBlock
implements IBE<BE>,
IWrenchable,
ProperWaterloggedBlock {
    public static final BooleanProperty DIAGONAL = BooleanProperty.m_61465_((String)"diagonal");

    protected TrackBufferBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DIAGONAL, (Comparable)Boolean.valueOf(false)));
    }

    public abstract Class<BE> getBlockEntityClass();

    public abstract BlockEntityType<? extends BE> getBlockEntityType();

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, DIAGONAL}));
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    protected abstract BlockState getCycledStyle(BlockState var1, Direction var2);

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.m_122434_() == ((Direction)originalState.m_61143_((Property)f_54117_)).m_122434_()) {
            return this.getCycledStyle(originalState, targetedFace);
        }
        return (BlockState)originalState.m_61124_((Property)f_54117_, (Comparable)((Direction)originalState.m_61143_((Property)f_54117_)).m_122424_());
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null && context instanceof BufferBlockPlaceContext) {
            BufferBlockPlaceContext bufferBlockPlaceContext = (BufferBlockPlaceContext)context;
            state = (BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)bufferBlockPlaceContext.facing)).m_61124_((Property)DIAGONAL, (Comparable)Boolean.valueOf(bufferBlockPlaceContext.diagonal));
        }
        return this.withWater(state, context);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return CRBlocks.TRACK_BUFFER.asStack();
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AdventureUtils.isAdventure(pPlayer)) {
            return InteractionResult.PASS;
        }
        return this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> be.applyDyeIfValid(pPlayer.m_21120_(pHand)));
    }

    public static int getBaseModelYRotationOf(BlockState state) {
        return TrackBufferBlock.getBaseModelYRotationOf(state, 0);
    }

    public static int getBaseModelYRotationOf(BlockState state, int offset) {
        return (int)(((Direction)state.m_61143_((Property)NarrowTrackBufferBlock.f_54117_)).m_122435_() + 180.0f + (float)offset) % 360;
    }
}

