/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock;

import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlockEntity;
import com.railwayteam.railways.content.buffer.headstock.HeadstockBlock;
import com.railwayteam.railways.content.buffer.headstock.HeadstockStyle;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.util.AdventureUtils;
import com.railwayteam.railways.util.client.OcclusionTestLevel;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.simibubi.create.content.decoration.copycat.CopycatSpecialCases;
import com.simibubi.create.content.decoration.copycat.WaterloggedCopycatBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatHeadstockBlock
extends WaterloggedCopycatBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HeadstockStyle> STYLE = HeadstockBlock.STYLE;
    public static final BooleanProperty UPSIDE_DOWN = HeadstockBlock.UPSIDE_DOWN;

    public CopycatHeadstockBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STYLE, (Comparable)((Object)HeadstockStyle.BUFFER))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING, STYLE, UPSIDE_DOWN}));
    }

    public boolean isAcceptedRegardless(BlockState material) {
        return CopycatSpecialCases.isBarsMaterial((BlockState)material);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        BlockPos diff = fromPos.m_121996_((Vec3i)toPos);
        int coord = facing.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (!(toState.m_60734_() instanceof CopycatHeadstockBlock)) {
            return facing != face.m_122424_();
        }
        return facing == ((Direction)toState.m_61143_((Property)FACING)).m_122424_() && (coord == 0 || coord != facing.m_122421_().m_122540_());
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        if (toPos.equals((Object)fromPos.m_121945_(facing))) {
            return false;
        }
        BlockPos diff = fromPos.m_121996_((Vec3i)toPos);
        int coord = facing.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (!(toState.m_60734_() instanceof CopycatHeadstockBlock)) {
            return coord != -facing.m_122421_().m_122540_();
        }
        if (CopycatHeadstockBlock.isOccluded(state, toState, facing.m_122424_())) {
            return true;
        }
        return toState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) == state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) && coord == 0;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122424_() == face;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        if (state.m_61143_((Property)FACING) == face) {
            return true;
        }
        return face.m_122434_().m_122478_() && face == Direction.DOWN ^ (Boolean)state.m_61143_((Property)UPSIDE_DOWN);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        pos = pos.m_7949_();
        BlockPos otherPos = pos.m_121945_(dir);
        BlockState material = CopycatHeadstockBlock.getMaterial((BlockGetter)level, (BlockPos)pos);
        BlockState otherMaterial = CopycatHeadstockBlock.getMaterial((BlockGetter)level, (BlockPos)otherPos);
        if (material == null) {
            material = AllBlocks.COPYCAT_BASE.getDefaultState();
        }
        if (otherMaterial == null) {
            otherMaterial = AllBlocks.COPYCAT_BASE.getDefaultState();
        }
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this)) {
            if (CopycatSpecialCases.isBarsMaterial((BlockState)material) && CopycatSpecialCases.isBarsMaterial((BlockState)otherMaterial)) {
                return state.m_61143_((Property)FACING) == neighborState.m_61143_((Property)FACING) && state.m_61143_((Property)UPSIDE_DOWN) == neighborState.m_61143_((Property)UPSIDE_DOWN);
            }
            if (material.m_60719_(otherMaterial, dir.m_122424_())) {
                return CopycatHeadstockBlock.isOccluded(state, neighborState, dir.m_122424_());
            }
            OcclusionTestLevel occlusionTestLevel = new OcclusionTestLevel(level);
            occlusionTestLevel.setBlock(pos, material);
            occlusionTestLevel.setBlock(otherPos, otherMaterial);
            if (material.m_60804_((BlockGetter)occlusionTestLevel, pos) && otherMaterial.m_60804_((BlockGetter)occlusionTestLevel, otherPos) && !Block.m_152444_((BlockState)otherMaterial, (BlockGetter)occlusionTestLevel, (BlockPos)pos, (Direction)dir.m_122424_(), (BlockPos)otherPos)) {
                occlusionTestLevel.clear();
                return CopycatHeadstockBlock.isOccluded(state, neighborState, dir.m_122424_());
            }
            occlusionTestLevel.clear();
        }
        return state.m_61143_((Property)FACING) == dir.m_122424_() && material.m_60719_(neighborState, dir.m_122424_());
    }

    private static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        other = (BlockState)other.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.m_122424_() == other.m_61143_((Property)FACING) && pDirection == facing) {
            return true;
        }
        if (other.m_61143_((Property)FACING) != facing) {
            return false;
        }
        if (other.m_61143_((Property)UPSIDE_DOWN) != state.m_61143_((Property)UPSIDE_DOWN)) {
            return false;
        }
        return pDirection.m_122434_() != facing.m_122434_() && pDirection.m_122434_().m_122479_();
    }

    public BlockEntityType<? extends CopycatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.COPYCAT_HEADSTOCK.get();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        if (result.m_19077_()) {
            return result;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            if (player != null && !player.m_7500_()) {
                Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
            }
            state.m_222967_((ServerLevel)world, pos, ItemStack.f_41583_, true);
            world.m_46961_(pos, false);
            this.playRemoveSound(world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = this.IWrenchable$onWrenched(state, context);
        if (result.m_19077_()) {
            return result;
        }
        return super.onWrenched(state, context);
    }

    private InteractionResult IWrenchable$onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockState rotated = this.getRotatedBlockState(state, context.m_43719_());
        if (rotated == state) {
            return InteractionResult.PASS;
        }
        if (!rotated.m_60710_((LevelReader)world, context.m_8083_())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)context.m_8083_(), (BlockState)this.updateAfterWrenched(rotated, context));
        BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
        if (be instanceof GeneratingKineticBlockEntity) {
            ((GeneratingKineticBlockEntity)be).reActivateSource = true;
        }
        if (world.m_8055_(context.m_8083_()) != state) {
            this.playRotateSound(world, context.m_8083_());
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            if (context.m_43719_().m_122434_().m_122478_()) {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
            } else {
                state = (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_43719_());
                if (context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() < 0.5) {
                    state = (BlockState)state.m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((HeadstockBlock)((Object)CRBlocks.HEADSTOCK.get())).m_5940_(state, level, pos, context);
    }

    protected VoxelShape getHeadstockShape(BlockState state) {
        return CRShapes.HEADSTOCK_PLAIN.get((Direction)state.m_61143_((Property)FACING));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AdventureUtils.isAdventure(pPlayer)) {
            return InteractionResult.PASS;
        }
        InteractionResult result = this.onBlockEntityUse((BlockGetter)pLevel, pPos, be -> {
            if (be instanceof CopycatHeadstockBlockEntity) {
                CopycatHeadstockBlockEntity copycatHeadstock = (CopycatHeadstockBlockEntity)be;
                return copycatHeadstock.applyDyeIfValid(pPlayer.m_21120_(pHand));
            }
            return InteractionResult.PASS;
        });
        if (result.m_19077_()) {
            return result;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor wrappedItemColor() {
        return new WrappedItemColor();
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return CRBlocks.COPYCAT_HEADSTOCK_GROUP.get((HeadstockStyle)((Object)state.m_61143_(STYLE))).asStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedItemColor
    implements ItemColor {
        public int m_92671_(ItemStack itemStack, int i) {
            return GrassColor.m_46415_((double)0.5, (double)1.0);
        }
    }
}

