/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.special.invisible;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyBlockEntity;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InvisibleBogeyBlock
extends AbstractBogeyBlock<InvisibleBogeyBlockEntity>
implements IBE<InvisibleBogeyBlockEntity>,
ProperWaterloggedBlock,
ISpecialBlockItemRequirement {
    public InvisibleBogeyBlock(BlockBehaviour.Properties props) {
        super(props, BogeySizes.SMALL);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public TrackMaterial.TrackType getTrackType(BogeyStyle style) {
        return CRTrackMaterials.CRTrackType.STANDARD;
    }

    public boolean isOnIncompatibleTrack(Carriage carriage, boolean leading) {
        CarriageBogey bogey;
        TravellingPoint point = leading ? carriage.getLeadingPoint() : carriage.getTrailingPoint();
        CarriageBogey carriageBogey = bogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        if (point.edge == null) {
            return false;
        }
        return point.edge.getTrackMaterial().trackType != this.getTrackType(bogey.getStyle()) && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.WIDE_GAUGE && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.NARROW_GAUGE && point.edge.getTrackMaterial().trackType != CRTrackMaterials.CRTrackType.MONORAIL;
    }

    public Set<TrackMaterial.TrackType> getValidPathfindingTypes(BogeyStyle style) {
        return ImmutableSet.of((Object)this.getTrackType(style), (Object)CRTrackMaterials.CRTrackType.WIDE_GAUGE, (Object)CRTrackMaterials.CRTrackType.NARROW_GAUGE, (Object)CRTrackMaterials.CRTrackType.MONORAIL);
    }

    public double getWheelPointSpacing() {
        return 2.0;
    }

    public double getWheelRadius() {
        return 0.40625;
    }

    public Vec3 getConnectorAnchorOffset() {
        return new Vec3(0.0, 0.21875, 1.0);
    }

    public BogeyStyle getDefaultStyle() {
        return CRBogeyStyles.INVISIBLE;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return AllBlocks.RAILWAY_CASING.asStack();
    }

    public Class<InvisibleBogeyBlockEntity> getBlockEntityClass() {
        return InvisibleBogeyBlockEntity.class;
    }

    public BlockEntityType<? extends InvisibleBogeyBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.INVISIBLE_BOGEY.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CRShapes.INVISIBLE_BOGEY;
    }
}

