/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GraveStoneTileEntity
extends BlockEntity
implements Nameable {
    protected Death death = new Death.Builder(GraveUtils.EMPTY_UUID, GraveUtils.EMPTY_UUID).build();
    protected Component customName;

    public GraveStoneTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.GRAVESTONE_TILEENTITY.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Death", (Tag)this.death.toNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Death")) {
            this.death = Death.fromNBT(compound.m_128469_("Death"));
        } else {
            UUID playerUUID = GraveUtils.EMPTY_UUID;
            try {
                playerUUID = UUID.fromString(compound.m_128461_("PlayerUUID"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Death.Builder builder = new Death.Builder(playerUUID, UUID.randomUUID());
            NonNullList items = NonNullList.m_122779_();
            ListTag list = compound.m_128437_("ItemStacks", 10);
            for (int i = 0; i < list.size(); ++i) {
                items.add((Object)ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
            }
            builder.additionalItems((NonNullList<ItemStack>)items);
            builder.playerName(compound.m_128461_("PlayerName"));
            builder.timestamp(compound.m_128454_("DeathTime"));
            this.death = builder.build();
        }
        if (compound.m_128441_("CustomName")) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.m_183515_(compound);
        return compound;
    }

    public Death getDeath() {
        return this.death;
    }

    public void setDeath(Death death) {
        this.death = death;
        this.m_6596_();
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.m_6596_();
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    protected Component getDefaultName() {
        String name = this.death.getPlayerName();
        if (name == null || name.isEmpty()) {
            return Component.m_237115_((String)((GraveStoneBlock)Main.GRAVESTONE.get()).m_7705_());
        }
        return Component.m_237110_((String)"message.gravestone.grave_of", (Object[])new Object[]{name});
    }

    @Nullable
    public Component getGraveName() {
        if (!this.death.getPlayerName().isEmpty()) {
            return Component.m_237113_((String)this.death.getPlayerName());
        }
        if (this.customName != null) {
            return this.customName;
        }
        return null;
    }
}

