/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import com.google.common.base.CaseFormat;
import ic2.api.items.electric.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.IC2ElectricItem;
import ic2.core.platform.player.KeyHelper;
import ic2.core.platform.rendering.IC2Textures;
import ic2.core.platform.rendering.features.item.IItemModel;
import ic2.core.platform.rendering.features.item.ILayeredItemModel;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.tooltips.ToolTipHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.Registry;

public class ItemMagnet
extends IC2ElectricItem
implements ILayeredItemModel,
IItemModel {
    public ItemMagnet() {
        super("magnet");
        Registry.REGISTRY.put(new ResourceLocation("gravisuit", "magnet"), (Item)this);
    }

    protected int getEnergyCost(ItemStack itemStack) {
        return 1;
    }

    public int getCapacity(ItemStack stack) {
        return GravisuitConfig.MAGNET_STORAGE.get();
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public int getTransferLimit(ItemStack stack) {
        return GravisuitConfig.MAGNET_TRANSFER.get();
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        this.tick(stack, level, player);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            this.tick(pStack, pLevel, player);
        }
    }

    private void tick(ItemStack stack, Level level, Player player) {
        if (ItemMagnet.getMagnetMode(stack) == MagnetMode.ATTRACT && ElectricItem.MANAGER.canUse(stack, 1)) {
            int range = GravisuitConfig.MAGNET_RANGE.get();
            AABB box = new AABB(player.m_20185_() - (double)range, player.m_20186_() - (double)range, player.m_20189_() - (double)range, player.m_20185_() + (double)range, player.m_20186_() + (double)range, player.m_20189_() + (double)range);
            List drops = level.m_142425_((EntityTypeTest)EntityType.f_20461_, box, item -> !(!item.m_6084_() || level.f_46443_ && item.f_19797_ <= 1 || item.m_32057_() != null && item.m_32057_().equals(player.m_20148_()) && item.m_32063_() || item.m_32055_().m_41619_() || item.getPersistentData().m_128441_("PreventRemoteMovement")));
            for (ItemEntity itemEntity : drops) {
                if (ElectricItem.MANAGER.canUse(stack, 1)) {
                    ItemStack beforeStack = itemEntity.m_32055_().m_41777_();
                    itemEntity.m_6123_(player);
                    ItemStack afterStack = itemEntity.m_32055_().m_41777_();
                    if (!itemEntity.m_213877_() && beforeStack.m_41613_() == afterStack.m_41613_()) continue;
                    ElectricItem.MANAGER.use(stack, 1, (LivingEntity)player);
                    continue;
                }
                ItemMagnet.saveMagnetMode(stack, MagnetMode.OFF);
                break;
            }
        }
    }

    public void addToolTip(ItemStack stack, Player player, TooltipFlag type, ToolTipHelper helper) {
        MagnetMode mode = ItemMagnet.getMagnetMode(stack);
        helper.addSimpleToolTip(Component.m_237110_((String)"item_info.toolMode", (Object[])new Object[]{Component.m_237115_((String)mode.localeName).m_130940_(mode.color)}).m_130940_(ChatFormatting.BLUE));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.MODE_KEY, KeyHelper.RIGHT_CLICK, new Object[]{Component.m_237115_((String)"item_info.multiModes").m_130940_(ChatFormatting.GRAY)}));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (IC2.PLATFORM.isSimulating()) {
            if (IC2.KEYBOARD.isModeSwitchKeyDown(playerIn)) {
                MagnetMode nextMode = ItemMagnet.getNextMagnetMode(stack);
                ItemMagnet.saveMagnetMode(stack, nextMode);
                playerIn.m_5661_((Component)Component.m_237110_((String)"item_info.toolMode", (Object[])new Object[]{Component.m_237115_((String)nextMode.localeName).m_130940_(nextMode.color)}).m_130940_(ChatFormatting.YELLOW), false);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean isLayered(ItemStack itemStack) {
        return true;
    }

    public int getLayerCount(ItemStack itemStack) {
        return ItemMagnet.getMagnetMode(itemStack) == MagnetMode.OFF ? 1 : 2;
    }

    public TextureAtlasSprite getSpriteForLayer(ItemStack itemStack, int i) {
        return (TextureAtlasSprite)IC2Textures.getMappedEntriesItem((String)"gravisuit", (String)"tools").get("magnet" + (i == 0 ? "" : "_active"));
    }

    public List<ItemStack> getModelTypes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack off = new ItemStack((ItemLike)this);
        ItemMagnet.saveMagnetMode(off, MagnetMode.OFF);
        list.add(off);
        ItemStack addToInventory = new ItemStack((ItemLike)this);
        ItemMagnet.saveMagnetMode(addToInventory, MagnetMode.ADD_TO_INVENTORY);
        list.add(addToInventory);
        ItemStack attract = new ItemStack((ItemLike)this);
        ItemMagnet.saveMagnetMode(attract, MagnetMode.ATTRACT);
        list.add(attract);
        return list;
    }

    public TextureAtlasSprite getSprite(ItemStack itemStack) {
        return (TextureAtlasSprite)IC2Textures.getMappedEntriesItem((String)"gravisuit", (String)"tools").get("magnet");
    }

    public int getModelIndexForStack(ItemStack itemStack, @Nullable LivingEntity livingEntity) {
        return ItemMagnet.getMagnetMode(itemStack).ordinal();
    }

    public static MagnetMode getMagnetMode(ItemStack tool) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        return MagnetMode.getFromId(tag.m_128445_("mode"));
    }

    public static MagnetMode getNextMagnetMode(ItemStack tool) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        return MagnetMode.getFromId(tag.m_128445_("mode") + 1);
    }

    public static void saveMagnetMode(ItemStack tool, MagnetMode mode) {
        CompoundTag tag = tool.m_41784_();
        tag.m_128344_("mode", (byte)mode.ordinal());
    }

    public static enum MagnetMode {
        OFF(ChatFormatting.AQUA),
        ADD_TO_INVENTORY(ChatFormatting.DARK_GREEN),
        ATTRACT(ChatFormatting.GOLD);

        private static final MagnetMode[] VALUES;
        public final ChatFormatting color;
        public final String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        public final String localeName = "message.text.mode." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());

        private MagnetMode(ChatFormatting color) {
            this.color = color;
        }

        public static MagnetMode getFromId(int ID) {
            return VALUES[ID % VALUES.length];
        }

        static {
            VALUES = MagnetMode.values();
        }
    }
}

