/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Multimap;
import ic2.api.crops.ICropModifier;
import ic2.api.items.electric.ElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioManager;
import ic2.core.item.tool.electric.ElectricWrenchTool;
import ic2.core.platform.player.KeyHelper;
import ic2.core.platform.registries.IC2Items;
import ic2.core.platform.rendering.IC2Textures;
import ic2.core.platform.rendering.features.item.IItemModel;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.tooltips.ToolTipHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.GravisuitSounds;
import trinsdar.gravisuit.util.Registry;
import trinsdar.gravisuit.util.RotationHelper;

public class ItemToolGravitool
extends ElectricWrenchTool
implements ICropModifier,
IItemModel {
    final ResourceLocation id;

    public ItemToolGravitool() {
        super("gravitool", null);
        this.tier = 2;
        this.losslessUses = -1;
        this.id = new ResourceLocation("gravisuit", "gravitool");
        Registry.REGISTRY.put(this.id, (Item)this);
    }

    public void addToolTip(ItemStack stack, Player player, TooltipFlag type, ToolTipHelper helper) {
        ToolMode mode = ItemToolGravitool.getToolMode(stack);
        helper.addSimpleToolTip(Component.m_237110_((String)"item_info.toolMode", (Object[])new Object[]{Component.m_237115_((String)mode.localeName).m_130940_(mode.color)}).m_130940_(ChatFormatting.BLUE));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.MODE_KEY, KeyHelper.RIGHT_CLICK, new Object[]{Component.m_237115_((String)"item_info.multiModes").m_130940_(ChatFormatting.GRAY)}));
        if (mode == ToolMode.HOE) {
            helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.BLOCK_CLICK, "tooltip.item.ic2.hoe.seedmode", new Object[0]));
        }
        if (mode == ToolMode.TREETAP && this.isImport(stack)) {
            helper.addSimpleToolTip("tooltip.item.ic2.electric_tree_tap.inv_import", new Object[0]);
        }
    }

    public ResourceLocation getRegistryName() {
        return this.id;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (IC2.PLATFORM.isSimulating()) {
            if (IC2.KEYBOARD.isModeSwitchKeyDown(playerIn)) {
                IC2.AUDIO.playSound((Object)playerIn, GravisuitSounds.toolGraviToolSound, AudioManager.SoundType.ITEM, IC2.AUDIO.getMasterVolume(), 1.0f);
                ToolMode nextMode = ItemToolGravitool.getNextToolMode(stack);
                ItemToolGravitool.saveToolMode(stack, nextMode);
                playerIn.m_5661_((Component)Component.m_237110_((String)"item_info.toolMode", (Object[])new Object[]{Component.m_237115_((String)nextMode.localeName).m_130940_(nextMode.color)}).m_130940_(ChatFormatting.YELLOW), false);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        ToolMode mode = ItemToolGravitool.getToolMode(stack);
        if (mode == ToolMode.WRENCH) {
            return super.onItemUseFirst(stack, context);
        }
        if (mode == ToolMode.SCREWDRIVER) {
            return RotationHelper.rotateBlock(context.m_43725_(), context.m_8083_(), context.m_43723_() != null && context.m_43723_().m_6144_() != context.m_43719_().equals((Object)Direction.DOWN)) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ToolMode mode = ItemToolGravitool.getToolMode(context.m_43722_());
        if (!IC2.KEYBOARD.isModeSwitchKeyDown(context.m_43723_())) {
            if (mode == ToolMode.WRENCH) {
                if (ModList.get().isLoaded("ae2")) {
                    return ItemToolGravitool.onPlayerUseBlock(context.m_43723_(), context.m_43725_(), context.m_43724_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_()));
                }
                return super.m_6225_(context);
            }
            if (mode == ToolMode.HOE) {
                return IC2Items.ELECTRIC_HOE.m_6225_(context);
            }
            if (mode == ToolMode.TREETAP) {
                return IC2Items.ELECTRIC_TREETAP.m_6225_(context);
            }
        }
        return super.m_6225_(context);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (ItemToolGravitool.getToolMode(stack) == ToolMode.HOE) {
            return IC2Items.ELECTRIC_HOE.m_6813_(stack, level, state, pos, miningEntity);
        }
        return super.m_6813_(stack, level, state, pos, miningEntity);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (ItemToolGravitool.getToolMode(stack) == ToolMode.HOE) {
            boolean isHoe = state.m_204336_(BlockTags.f_144281_);
            return super.isCorrectToolForDrops(stack, state) || isHoe;
        }
        return super.isCorrectToolForDrops(stack, state);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) ? Tiers.IRON.m_6624_() : super.m_8102_(stack, state);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ItemToolGravitool.getToolMode(stack) == ToolMode.HOE && ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (ItemToolGravitool.getToolMode(stack) == ToolMode.HOE) {
            return IC2Items.ELECTRIC_HOE.getAttributeModifiers(slot, stack);
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public int getCapacity(ItemStack stack) {
        return GravisuitConfig.GRAVITOOL_STORAGE.get();
    }

    public int getTransferLimit(ItemStack stack) {
        return GravisuitConfig.GRAVITOOL_TRANSFER.get();
    }

    public boolean canOverrideLoss(ItemStack stack) {
        return true;
    }

    public void onLossPrevented(Player player, ItemStack stack) {
    }

    public boolean hasBigCost(ItemStack stack) {
        return false;
    }

    public boolean canChangeSeedMode(ItemStack stack) {
        return ItemToolGravitool.getToolMode(stack) == ToolMode.HOE;
    }

    public boolean shouldRenderOverlay(ItemStack stack) {
        return ItemToolGravitool.getToolMode(stack) == ToolMode.WRENCH;
    }

    public List<ItemStack> getModelTypes() {
        ObjectArrayList stacks = new ObjectArrayList();
        int modes = ToolMode.values().length;
        for (int i = 0; i < modes; ++i) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_().m_128344_("mode", (byte)i);
            stacks.add(stack);
        }
        return stacks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getSprite(ItemStack stack) {
        Map textures = IC2Textures.getMappedEntriesItem((String)"gravisuit", (String)"tools/gravitool");
        ToolMode mode = ItemToolGravitool.getToolMode(stack);
        return (TextureAtlasSprite)textures.get(mode.name);
    }

    public int getModelIndexForStack(ItemStack stack, @Nullable LivingEntity livingEntity) {
        return ItemToolGravitool.getToolMode(stack).ordinal() + 1;
    }

    public boolean isImport(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).m_128471_("inv_import");
    }

    public static InteractionResult onPlayerUseBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity be;
        if (player.m_5833_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (InteractionUtil.isInAlternateUseMode((Player)player) && (be = level.m_7702_(hitResult.m_82425_())) instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity baseBlockEntity = (AEBaseBlockEntity)be;
            if (!Platform.hasPermissions((DimensionalBlockPos)new DimensionalBlockPos(level, hitResult.m_82425_()), (Player)player)) {
                return InteractionResult.FAIL;
            }
            ElectricItem.MANAGER.use(player.m_21205_(), 50, (LivingEntity)player);
            return baseBlockEntity.disassembleWithWrench(player, level, hitResult);
        }
        return InteractionResult.PASS;
    }

    public static ToolMode getToolMode(ItemStack tool) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        return ToolMode.getFromId(tag.m_128445_("mode"));
    }

    public static ToolMode getNextToolMode(ItemStack tool) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)tool);
        return ToolMode.getFromId(tag.m_128445_("mode") + 1);
    }

    public static void saveToolMode(ItemStack tool, ToolMode mode) {
        CompoundTag tag = tool.m_41784_();
        tag.m_128344_("mode", (byte)mode.ordinal());
    }

    public static enum ToolMode {
        WRENCH(ChatFormatting.AQUA),
        HOE(ChatFormatting.DARK_GREEN),
        TREETAP(ChatFormatting.GOLD),
        SCREWDRIVER(ChatFormatting.LIGHT_PURPLE);

        private static final ToolMode[] VALUES;
        public final ChatFormatting color;
        public final String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        public final String localeName = "message.text.mode." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());

        private ToolMode(ChatFormatting color) {
            this.color = color;
        }

        public static ToolMode getFromId(int ID) {
            return VALUES[ID % VALUES.length];
        }

        static {
            VALUES = ToolMode.values();
        }
    }
}

