/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import ic2.api.items.electric.ElectricItem;
import ic2.core.IC2;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasHeldSlotInventory;
import ic2.core.inventory.base.IPortableInventory;
import ic2.core.item.base.IC2ElectricItem;
import ic2.core.platform.player.KeyHelper;
import ic2.core.platform.rendering.IC2Textures;
import ic2.core.platform.rendering.features.item.IItemModel;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.tooltips.ToolTipHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;
import trinsdar.gravisuit.items.container.ItemInventoryVoider;
import trinsdar.gravisuit.util.GravisuitConfig;
import trinsdar.gravisuit.util.Registry;

public class ItemVoider
extends IC2ElectricItem
implements IItemModel,
IHasHeldSlotInventory {
    public ItemVoider() {
        super("voider");
        Registry.REGISTRY.put(new ResourceLocation("gravisuit", "voider"), (Item)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected int getEnergyCost(ItemStack itemStack) {
        return 5;
    }

    public int getCapacity(ItemStack stack) {
        return GravisuitConfig.VOIDER_STORAGE.get();
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public int getTransferLimit(ItemStack stack) {
        return GravisuitConfig.VOIDER_TRANSFER.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToolTip(ItemStack stack, Player player, TooltipFlag type, ToolTipHelper helper) {
        CompoundTag nbt = StackUtil.getNbtData((ItemStack)stack);
        boolean active = nbt.m_128471_("active");
        helper.addSimpleToolTip("item_info.voider_mode", new Object[]{this.translate("item_info." + (active ? "enabled" : "disabled"))});
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.MODE_KEY, KeyHelper.RIGHT_CLICK, "item_info.voider_toggle", new Object[0]));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.RIGHT_CLICK, KeyHelper.SIDE_INV_KEY, "tooltip.ic2.open_item_inventory", new Object[0]));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.SNEAK_KEY, KeyHelper.RIGHT_CLICK, "item_info.voider_use", new Object[0]));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (IC2.PLATFORM.isSimulating()) {
            if (IC2.KEYBOARD.isSideInventoryKeyDown(player)) {
                IC2.PLATFORM.launchGui(player, hand, Direction.NORTH, (IHasGui)this.getInventory(player, hand, stack));
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            CompoundTag nbt = stack.m_41784_();
            boolean active = nbt.m_128471_("active");
            if (IC2.KEYBOARD.isModeSwitchKeyDown(player)) {
                nbt.m_128379_("active", !active);
                player.m_5661_((Component)this.translate("message.voider." + (!active ? "on" : "off")), false);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (IC2.KEYBOARD.isSneakKeyDown(player) && this.checkForItemsToVoid(player, stack, false)) {
                player.m_5661_((Component)this.translate("message.voider.void_inventory").m_130940_(ChatFormatting.GOLD), false);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public IPortableInventory getInventory(Player player, InteractionHand interactionHand, ItemStack itemStack) {
        return new ItemInventoryVoider(player, this, itemStack, null).load(itemStack);
    }

    public IPortableInventory getInventory(Player player, ItemStack itemStack, Slot slot) {
        return new ItemInventoryVoider(player, this, itemStack, slot).load(itemStack);
    }

    public List<ItemStack> getModelTypes() {
        ObjectArrayList types = new ObjectArrayList();
        ItemStack inactive = new ItemStack((ItemLike)this);
        ItemStack active = new ItemStack((ItemLike)this);
        active.m_41784_().m_128379_("active", true);
        types.add(inactive);
        types.add(active);
        return types;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getSprite(ItemStack stack) {
        String suffix = StackUtil.getNbtData((ItemStack)stack).m_128471_("active") ? "_active" : "";
        return (TextureAtlasSprite)IC2Textures.getMappedEntriesItem((String)"gravisuit", (String)"tools").get("voider" + suffix);
    }

    public int getModelIndexForStack(ItemStack stack, @Nullable LivingEntity livingEntity) {
        return StackUtil.getNbtData((ItemStack)stack).m_128471_("active") ? 1 : 0;
    }

    @SubscribeEvent
    public void onItemPickupEvent(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        ItemStack voider = Registry.findStack((Item)this, player);
        this.checkForItemsToVoid(player, voider, true);
    }

    private boolean checkForItemsToVoid(Player player, ItemStack voider, boolean checkActive) {
        List<ItemStack> toVoid;
        List<ItemStack> filter;
        CompoundTag tag;
        if (!(voider.m_41619_() || !(tag = StackUtil.getNbtData((ItemStack)voider)).m_128471_("active") && checkActive || !tag.m_128425_("items", 9) || (filter = this.voidFilter(tag.m_128437_("items", 10))).isEmpty() || (toVoid = this.drops(player, filter)).isEmpty())) {
            boolean success = false;
            for (ItemStack drop : toVoid) {
                if (!ElectricItem.MANAGER.canUse(voider, this.getEnergyCost(voider))) continue;
                drop.m_41764_(0);
                ElectricItem.MANAGER.use(voider, this.getEnergyCost(voider), (LivingEntity)player);
                success = true;
            }
            if (success) {
                return true;
            }
        }
        return false;
    }

    private List<ItemStack> drops(Player player, List<ItemStack> filter) {
        ArrayList<ItemStack> toVoid = new ArrayList<ItemStack>();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!StackUtil.containsItemStack(filter, (ItemStack)stack)) continue;
            toVoid.add(stack);
        }
        return toVoid;
    }

    private List<ItemStack> voidFilter(ListTag tag) {
        ObjectArrayList items = new ObjectArrayList();
        tag.forEach(arg_0 -> ItemVoider.lambda$voidFilter$0((List)items, arg_0));
        return items;
    }

    private static /* synthetic */ void lambda$voidFilter$0(List items, Tag tag1) {
        if (tag1 instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag1;
            items.add(ItemStack.m_41712_((CompoundTag)nbt));
        }
    }
}

