/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.mixin;

import ic2.api.items.electric.ElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioManager;
import ic2.core.item.tool.electric.AdvancedDrill;
import ic2.core.item.tool.electric.DrillTool;
import ic2.core.platform.player.KeyHelper;
import ic2.core.platform.rendering.IC2Textures;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.tooltips.ToolTipHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import trinsdar.gravisuit.items.tools.DrillMode;
import trinsdar.gravisuit.util.GravisuitSounds;

@Mixin(value={AdvancedDrill.class})
public class AdvancedDrillMixin
extends DrillTool {
    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void injectInit(CallbackInfo ci) {
        this.tier = 2;
    }

    public int getEnergyCost(ItemStack stack) {
        return this.getDrillMode(stack) == DrillMode.NORMAL ? 160 : 80;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)IC2Textures.getMappedEntriesItem((String)"gravisuit", (String)"tools").get("advanced_drill");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToolTip(ItemStack stack, Player player, TooltipFlag type, ToolTipHelper helper) {
        DrillMode mode = this.getDrillMode(stack);
        helper.addSimpleToolTip(Component.m_237110_((String)"item_info.toolMode", (Object[])new Object[]{Component.m_237115_((String)mode.localeName).m_130940_(mode.color)}).m_130940_(ChatFormatting.BLUE));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.MODE_KEY, KeyHelper.RIGHT_CLICK, new Object[]{Component.m_237115_((String)"item_info.multiModes").m_130940_(ChatFormatting.GRAY)}));
        super.addToolTip(stack, player, type, helper);
        helper.addSimpleToolTip(Component.m_237115_((String)"item_info.modified_by_gravisuit").m_130940_(ChatFormatting.RED));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (IC2.PLATFORM.isSimulating()) {
            if (IC2.KEYBOARD.isModeSwitchKeyDown(playerIn)) {
                IC2.AUDIO.playSound((Object)playerIn, GravisuitSounds.toolGraviToolSound, AudioManager.SoundType.ITEM, IC2.AUDIO.getMasterVolume(), 1.0f);
                DrillMode nextMode = this.getNextDrillMode(stack);
                DrillMode.saveDrillMode(stack, nextMode);
                playerIn.m_5661_((Component)Component.m_237110_((String)"item_info.toolMode", (Object[])new Object[]{Component.m_237115_((String)nextMode.localeName).m_130940_(nextMode.color)}).m_130940_(ChatFormatting.YELLOW), false);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (!ElectricItem.MANAGER.canUse(stack, this.getEnergyCost(stack))) {
            return 1.0f;
        }
        if (this.isCorrectToolForDrops(stack, state)) {
            return switch (this.getDrillMode(stack)) {
                default -> throw new IncompatibleClassChangeError();
                case DrillMode.NORMAL -> 24.0f;
                case DrillMode.LOW_POWER -> 16.0f;
                case DrillMode.FINE -> 8.0f;
                case DrillMode.BIG_HOLES -> 43.2f;
            };
        }
        return 1.0f;
    }

    @Overwrite(remap=false)
    public boolean isMultiMining(ItemStack stack) {
        return this.getDrillMode(stack) == DrillMode.BIG_HOLES;
    }

    @Unique
    private DrillMode getDrillMode(ItemStack stack) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)stack);
        boolean multimine = tag.m_128471_("multi");
        if (multimine) {
            DrillMode.saveDrillMode(stack, DrillMode.BIG_HOLES);
            StackUtil.getNbtData((ItemStack)stack).m_128473_("multi");
        }
        return DrillMode.getFromId(tag.m_128445_("mode"));
    }

    @Unique
    private DrillMode getNextDrillMode(ItemStack stack) {
        CompoundTag tag = StackUtil.getNbtData((ItemStack)stack);
        boolean multimine = tag.m_128471_("multi");
        if (multimine) {
            DrillMode.saveDrillMode(stack, DrillMode.BIG_HOLES);
            StackUtil.getNbtData((ItemStack)stack).m_128473_("multi");
        }
        return DrillMode.getFromId(tag.m_128445_("mode") + 1);
    }
}

