/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.util;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.Config;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.config.ConfigSection;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.toml.TomlParser;
import ic2.core.IC2;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class GravisuitConfig {
    public static ConfigEntry.EnumValue<Positions> POSITIONS;
    public static ConfigEntry.EnumValue<HudMode> HUD_MODE;
    public static ConfigEntry.IntValue ADVANCED_ELECTRIC_JETPACK_STORAGE;
    public static ConfigEntry.IntValue ADVANCED_NUCLEAR_JETPACK_STORAGE;
    public static ConfigEntry.IntValue ADVANCED_LAPPACK_STORAGE;
    public static ConfigEntry.IntValue ULTIMATE_LAPPACK_STORAGE;
    public static ConfigEntry.IntValue GRAVITATION_JETPACK_STORAGE;
    public static ConfigEntry.IntValue NUCLEAR_GRAVITATION_JETPACK_STORAGE;
    public static ConfigEntry.IntValue GRAVITOOL_STORAGE;
    public static ConfigEntry.IntValue VAJRA_STORAGE;
    public static ConfigEntry.IntValue RELOCATOR_STORAGE;
    public static ConfigEntry.IntValue MAGNET_STORAGE;
    public static ConfigEntry.IntValue VOIDER_STORAGE;
    public static ConfigEntry.IntValue ADVANCED_ELECTRIC_JETPACK_TRANSFER;
    public static ConfigEntry.IntValue ADVANCED_LAPPACK_TRANSFER;
    public static ConfigEntry.IntValue ULTIMATE_LAPPACK_TRANSFER;
    public static ConfigEntry.IntValue GRAVITATION_JETPACK_TRANSFER;
    public static ConfigEntry.IntValue GRAVITOOL_TRANSFER;
    public static ConfigEntry.IntValue VAJRA_TRANSFER;
    public static ConfigEntry.IntValue RELOCATOR_TRANSFER;
    public static ConfigEntry.IntValue MAGNET_TRANSFER;
    public static ConfigEntry.IntValue VOIDER_TRANSFER;
    public static ConfigEntry.BoolValue ADVANCED_JETPACK_PROVIDE_ENERGY;
    public static ConfigEntry.BoolValue ADVANCED_N_JETPACK_PROVIDE_ENERGY;
    public static ConfigEntry.BoolValue COMPACTED_JETPACK_PROVIDE_ENERGY;
    public static ConfigEntry.BoolValue COMPACTED_N_JETPACK_PROVIDE_ENERGY;
    public static ConfigEntry.BoolValue GRAVITATION_JETPACK_PROVIDE_ENERGY;
    public static ConfigEntry.BoolValue GRAVITATION_N_JETPACK_PROVIDE_ENERGY;
    public static ConfigEntry.IntValue MAGNET_RANGE;
    static ConfigHandler CONFIG;
    private static final TomlParser PARSER;

    public static void createConfig() {
        CommentedConfig forgeConfig;
        Config config = new Config("ic2c/gravisuit");
        ConfigSection client = config.add("client");
        POSITIONS = client.addEnum("positions", (Enum)Positions.TOPLEFT, Positions.class, new String[]{"Position of the gravisuit Hud"});
        HUD_MODE = client.addEnum("hud_mode", (Enum)HudMode.ON, HudMode.class, new String[]{"Hud mode for the gravisuit Hud"});
        ConfigSection powerValues = config.add("power_values");
        ConfigSection storage = powerValues.addSubSection("storage");
        ADVANCED_ELECTRIC_JETPACK_STORAGE = storage.addInt("advanced_electric_jetpack_storage", 200000).setMin(1);
        ADVANCED_NUCLEAR_JETPACK_STORAGE = storage.addInt("advanced_nuclear_jetpack_storage", 200000).setMin(1);
        ADVANCED_LAPPACK_STORAGE = storage.addInt("advanced_lappack_storage", 600000).setMin(1);
        ULTIMATE_LAPPACK_STORAGE = storage.addInt("ultimate_lappack_storage", 10000000).setMin(1);
        GRAVITATION_JETPACK_STORAGE = storage.addInt("gravitation_jetpack_storage", 500000).setMin(1);
        NUCLEAR_GRAVITATION_JETPACK_STORAGE = storage.addInt("nuclear_gravitation_jetpack_storage", 500000).setMin(1);
        GRAVITOOL_STORAGE = storage.addInt("gravitool_storage", 50000).setMin(1);
        VAJRA_STORAGE = storage.addInt("vajra_storage", 3000000).setMin(1);
        RELOCATOR_STORAGE = storage.addInt("relocator_storage", 50000000).setMin(1);
        MAGNET_STORAGE = storage.addInt("magnet_storage", 10000).setMin(1);
        VOIDER_STORAGE = storage.addInt("voider_storage", 10000).setMin(1);
        ConfigSection transfer = powerValues.addSubSection("transfer");
        ADVANCED_ELECTRIC_JETPACK_TRANSFER = transfer.addInt("advanced_electric_jetpack_transfer", 500).setMin(1);
        ADVANCED_LAPPACK_TRANSFER = transfer.addInt("advanced_lappack_transfer", 500).setMin(1);
        ULTIMATE_LAPPACK_TRANSFER = transfer.addInt("ultimate_lappack_transfer", 4000).setMin(1);
        GRAVITATION_JETPACK_TRANSFER = transfer.addInt("gravitation_jetpack_transfer", 1000).setMin(1);
        GRAVITOOL_TRANSFER = transfer.addInt("gravitool_transfer", 400).setMin(1);
        VAJRA_TRANSFER = transfer.addInt("vajra_transfer", 1000).setMin(1);
        RELOCATOR_TRANSFER = transfer.addInt("relocator_transfer", 25000).setMin(1);
        MAGNET_TRANSFER = transfer.addInt("magnet_transfer", 500).setMin(1);
        VOIDER_TRANSFER = transfer.addInt("voider_transfer", 500).setMin(1);
        ConfigSection misc = config.add("misc");
        ADVANCED_JETPACK_PROVIDE_ENERGY = misc.addBool("advanced_jetpack_provide_energy", false, new String[]{"Enables the Advanced Electric jetpack charging items. Default: false"});
        ADVANCED_N_JETPACK_PROVIDE_ENERGY = misc.addBool("advanced_n_jetpack_provide_energy", true, new String[]{"Enables the Advanced Nuclear jetpack charging items. Default: true"});
        COMPACTED_JETPACK_PROVIDE_ENERGY = misc.addBool("compacted_jetpack_provide_energy", false, new String[]{"Enables the Compacted jetpack charging items. Default: false"});
        COMPACTED_N_JETPACK_PROVIDE_ENERGY = misc.addBool("compacted_n_jetpack_provide_energy", true, new String[]{"Enables the Compacted Nuclear jetpack charging items. Default: true"});
        GRAVITATION_JETPACK_PROVIDE_ENERGY = misc.addBool("gravitation_jetpack_provide_energy", false, new String[]{"Enables the Gravitation jetpack charging items. Default: false"});
        GRAVITATION_N_JETPACK_PROVIDE_ENERGY = misc.addBool("gravitation_n_jetpack_provide_energy", true, new String[]{"Enables the Gravitation Nuclear jetpack charging items. Default: true"});
        MAGNET_RANGE = misc.addInt("magnet_range", 8).setMin(1).setMax(16);
        CONFIG = CarbonConfig.CONFIGS.createConfig(config);
        CONFIG.register();
        Path configFile = Path.of(FMLPaths.CONFIGDIR.get().toString(), "gravisuit-client.toml");
        if (Files.exists(configFile, new LinkOption[0])) {
            try {
                forgeConfig = (CommentedConfig)PARSER.parse(configFile, FileNotFoundAction.READ_NOTHING);
                Object object = forgeConfig.get("POSITION");
                if (object instanceof String) {
                    String string = (String)object;
                    try {
                        Positions centerIngot = Positions.valueOf(string);
                        POSITIONS.set((Object)centerIngot);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                Files.move(configFile, Path.of(FMLPaths.CONFIGDIR.get().toString(), "gravisuit-client-replaced.toml.bak"), new CopyOption[0]);
                CONFIG.save();
            }
            catch (Exception e) {
                IC2.LOGGER.error((Object)e);
            }
        }
        if (Files.exists(configFile = Path.of(FMLPaths.CONFIGDIR.get().toString(), "gravisuit-common.toml"), new LinkOption[0])) {
            forgeConfig = (CommentedConfig)PARSER.parse(configFile, FileNotFoundAction.READ_NOTHING);
            try {
                String path = "PowerValues.Storage";
                ADVANCED_ELECTRIC_JETPACK_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".ADVANCED_ELECTRIC_JETPACK_STORAGE")));
                ADVANCED_NUCLEAR_JETPACK_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".ADVANCED_NUCLEAR_JETPACK_STORAGE")));
                ADVANCED_LAPPACK_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".ADVANCED_LAPPACK_STORAGE")));
                ULTIMATE_LAPPACK_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".ULTIMATE_LAPPACK_STORAGE")));
                GRAVITATION_JETPACK_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".GRAVITATION_JETPACK_STORAGE")));
                NUCLEAR_GRAVITATION_JETPACK_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".NUCLEAR_GRAVITATION_JETPACK_STORAGE")));
                GRAVITOOL_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".GRAVITOOL_STORAGE")));
                VAJRA_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".VAJRA_STORAGE")));
                RELOCATOR_STORAGE.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".RELOCATOR_STORAGE")));
                path = "PowerValues.Transfer";
                ADVANCED_ELECTRIC_JETPACK_TRANSFER.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".ADVANCED_ELECTRIC_JETPACK_TRANSFER")));
                ADVANCED_LAPPACK_TRANSFER.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".ADVANCED_LAPPACK_TRANSFER")));
                ULTIMATE_LAPPACK_TRANSFER.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".ULTIMATE_LAPPACK_TRANSFER")));
                GRAVITATION_JETPACK_TRANSFER.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".GRAVITATION_JETPACK_TRANSFER")));
                GRAVITOOL_TRANSFER.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".GRAVITOOL_TRANSFER")));
                VAJRA_TRANSFER.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".VAJRA_TRANSFER")));
                RELOCATOR_TRANSFER.set(Integer.valueOf(GravisuitConfig.getInt(forgeConfig, path + ".RELOCATOR_TRANSFER")));
                path = "Misc";
                ADVANCED_JETPACK_PROVIDE_ENERGY.set((Object)GravisuitConfig.getBoolean(forgeConfig, path + ".ADVANCED_JETPACK_PROVIDE_ENERGY"));
                ADVANCED_N_JETPACK_PROVIDE_ENERGY.set((Object)GravisuitConfig.getBoolean(forgeConfig, path + ".ADVANCED_N_JETPACK_PROVIDE_ENERGY"));
                COMPACTED_JETPACK_PROVIDE_ENERGY.set((Object)GravisuitConfig.getBoolean(forgeConfig, path + ".COMPACTEd_JETPACK_PROVIDE_ENERGY"));
                COMPACTED_N_JETPACK_PROVIDE_ENERGY.set((Object)GravisuitConfig.getBoolean(forgeConfig, path + ".COMPACTEd_N_JETPACK_PROVIDE_ENERGY"));
                GRAVITATION_JETPACK_PROVIDE_ENERGY.set((Object)GravisuitConfig.getBoolean(forgeConfig, path + ".GRAVITATION_JETPACK_PROVIDE_ENERGY"));
                GRAVITATION_N_JETPACK_PROVIDE_ENERGY.set((Object)GravisuitConfig.getBoolean(forgeConfig, path + ".GRAVITATION_N_JETPACK_PROVIDE_ENERGY"));
                Files.move(configFile, Path.of(FMLPaths.CONFIGDIR.get().toString(), "gravisuit-common-replaced.toml.bak"), new CopyOption[0]);
                CONFIG.save();
            }
            catch (Exception e) {
                IC2.LOGGER.error((Object)e);
            }
        }
    }

    private static int getInt(CommentedConfig config, String path) {
        if (!config.contains(path)) {
            throw new RuntimeException("Path does not exist in old config! " + path);
        }
        return config.getInt(path);
    }

    private static boolean getBoolean(CommentedConfig config, String path) {
        if (!config.contains(path)) {
            throw new RuntimeException("Path does not exist in old config! " + path);
        }
        return (Boolean)config.getRaw(path);
    }

    static {
        PARSER = new TomlParser();
    }

    public static enum Positions {
        TOPLEFT,
        TOPRIGHT,
        TOPMIDDLE,
        BOTTOMLEFT,
        BOTTOMRIGHT,
        BOTTOMLEFT_HOTBAR,
        BOTTOMRIGHT_HOTBAR;

    }

    public static enum HudMode {
        OFF,
        REQUIRES_HUD_UPGRADE,
        ON;

    }
}

