/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;

public enum BlockSide implements StringRepresentable
{
    TOP("top"),
    BOTTOM("bottom"),
    FRONT("front"),
    BACK("back"),
    LEFT("left"),
    RIGHT("right");

    private final String name;
    private static final Map<String, BlockSide> NAME_VALUES;

    private BlockSide(String name) {
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public static BlockSide fromName(String name) {
        return NAME_VALUES.getOrDefault(name, FRONT);
    }

    public static BlockSide fromDirection(Direction direction, Direction baseHorizontalDirection, VerticalFacing baseVerticalFacing) {
        if (direction == baseHorizontalDirection.m_122427_()) {
            return LEFT;
        }
        if (direction == baseHorizontalDirection.m_122428_()) {
            return RIGHT;
        }
        if (baseVerticalFacing == VerticalFacing.NO) {
            if (direction == Direction.UP) {
                return TOP;
            }
            if (direction == Direction.DOWN) {
                return BOTTOM;
            }
            if (direction == baseHorizontalDirection) {
                return FRONT;
            }
            if (direction == baseHorizontalDirection.m_122424_()) {
                return BACK;
            }
        }
        if (direction == baseVerticalFacing.getDirection()) {
            return FRONT;
        }
        if (direction == baseVerticalFacing.getDirection().m_122424_()) {
            return BACK;
        }
        if (baseVerticalFacing == VerticalFacing.UP) {
            if (direction == baseHorizontalDirection) {
                return BOTTOM;
            }
            if (direction == baseHorizontalDirection.m_122424_()) {
                return TOP;
            }
        }
        if (direction == baseHorizontalDirection) {
            return TOP;
        }
        return BOTTOM;
    }

    public Direction toDirection(Direction baseHorizontalDirection, VerticalFacing baseVerticalFacing) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TOP -> {
                if (baseVerticalFacing == VerticalFacing.NO) {
                    if (baseHorizontalDirection == Direction.UP) {
                        yield Direction.SOUTH;
                    }
                    if (baseHorizontalDirection == Direction.DOWN) {
                        yield Direction.NORTH;
                    }
                    yield Direction.UP;
                }
                if (baseVerticalFacing == VerticalFacing.UP) {
                    yield baseHorizontalDirection.m_122424_();
                }
                yield baseHorizontalDirection;
            }
            case BOTTOM -> {
                if (baseVerticalFacing == VerticalFacing.NO) {
                    if (baseHorizontalDirection == Direction.UP) {
                        yield Direction.NORTH;
                    }
                    if (baseHorizontalDirection == Direction.DOWN) {
                        yield Direction.SOUTH;
                    }
                    yield Direction.DOWN;
                }
                if (baseVerticalFacing == VerticalFacing.UP) {
                    yield baseHorizontalDirection;
                }
                yield baseHorizontalDirection.m_122424_();
            }
            case FRONT -> {
                if (baseVerticalFacing == VerticalFacing.NO) {
                    yield baseHorizontalDirection;
                }
                yield baseVerticalFacing.getDirection();
            }
            case BACK -> {
                if (baseVerticalFacing == VerticalFacing.NO) {
                    yield baseHorizontalDirection.m_122424_();
                }
                yield baseVerticalFacing.getDirection().m_122424_();
            }
            case LEFT -> {
                if (baseVerticalFacing == VerticalFacing.NO && baseHorizontalDirection.m_122434_() == Direction.Axis.Y) {
                    yield Direction.EAST;
                }
                yield baseHorizontalDirection.m_122427_();
            }
            case RIGHT -> baseVerticalFacing == VerticalFacing.NO && baseHorizontalDirection.m_122434_() == Direction.Axis.Y ? Direction.WEST : baseHorizontalDirection.m_122428_();
        };
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockSide value : BlockSide.values()) {
            builder.put((Object)value.m_7912_(), (Object)value);
        }
        NAME_VALUES = builder.build();
    }
}

