/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class StorageTierUpgradeRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final ShapedRecipe compose;

    public StorageTierUpgradeRecipe(ShapedRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.getRecipeWidth(), compose.getRecipeHeight(), compose.m_7527_(), compose.m_8043_());
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public boolean m_5818_(CraftingContainer pInv, Level pLevel) {
        return super.m_5818_(pInv, pLevel) && this.getOriginalStorage(pInv).map(storage -> !(storage.m_41720_() instanceof WoodStorageBlockItem) || !WoodStorageBlockItem.isPacked(storage)).orElse(false) != false;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack upgradedStorage = super.m_5874_(inv);
        this.getOriginalStorage(inv).ifPresent(originalStorage -> upgradedStorage.m_41751_(originalStorage.m_41783_()));
        Item item = upgradedStorage.m_41720_();
        if (item instanceof ShulkerBoxItem) {
            ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)item;
            upgradedStorage.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
                shulkerBoxItem.setNumberOfInventorySlots(upgradedStorage, wrapper.getDefaultNumberOfInventorySlots());
                shulkerBoxItem.setNumberOfUpgradeSlots(upgradedStorage, wrapper.getDefaultNumberOfUpgradeSlots());
            });
        }
        return upgradedStorage;
    }

    public boolean m_5598_() {
        return true;
    }

    private Optional<ItemStack> getOriginalStorage(CraftingContainer inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = inv.m_8020_(slot);
            Item item = slotStack.m_41720_();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).m_40614_() instanceof IStorageBlock)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModBlocks.STORAGE_TIER_UPGRADE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, StorageTierUpgradeRecipe> {
        public Serializer() {
            super(StorageTierUpgradeRecipe::new, RecipeSerializer.f_44076_);
        }
    }
}

