/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MapType;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.integration.StaticMapIcon;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class WaypointMapIcon
extends StaticMapIcon {
    public final Waypoint waypoint;
    public Icon outsideIcon;
    public double distance;
    public int alpha;

    public WaypointMapIcon(Waypoint w) {
        super(new Vec3((double)w.x + 0.5, (double)w.y + 0.5, (double)w.z + 0.5));
        this.waypoint = w;
        this.outsideIcon = Color4I.EMPTY;
    }

    @Override
    public boolean isVisible(MapType mapType, double distanceToPlayer, boolean outsideVisibleArea) {
        if (outsideVisibleArea || distanceToPlayer > this.waypoint.getDrawDistance(mapType.isMinimap())) {
            return false;
        }
        return !mapType.isWorldIcon() || distanceToPlayer >= 0.5;
    }

    @Override
    public boolean isIconOnEdge(MapType mapType, boolean outsideVisibleArea) {
        return !outsideVisibleArea;
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public void addTooltip(TooltipList list) {
        list.string(this.waypoint.name);
        super.addTooltip(list);
    }

    @Override
    public boolean mousePressed(LargeMapScreen screen, MouseButton button) {
        if (super.mousePressed(screen, button)) {
            return true;
        }
        if (button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((Component)Component.m_237113_((String)this.waypoint.name), this.icon, () -> {}));
            contextMenu.add(ContextMenuItem.SEPARATOR);
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"gui.rename"), Icons.CHAT, () -> {
                StringConfig config = new StringConfig();
                config.defaultValue = "";
                config.value = this.waypoint.name;
                config.onClicked(MouseButton.LEFT, b -> {
                    if (b) {
                        this.waypoint.name = (String)config.value;
                        this.waypoint.dimension.saveData = true;
                    }
                    screen.openGui();
                });
            }));
            if (this.waypoint.type.canChangeColor) {
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbchunks.gui.change_color"), Icons.COLOR_RGB, () -> {
                    int r = this.waypoint.color >> 16 & 0xFF;
                    int g = this.waypoint.color >> 8 & 0xFF;
                    int b = this.waypoint.color >> 0 & 0xFF;
                    float[] hsb = Color.RGBtoHSB(r, g, b, new float[3]);
                    float add = Widget.isShiftKeyDown() ? -0.083333336f : 0.083333336f;
                    Color4I col = Color4I.hsb((float)(hsb[0] + add), (float)hsb[1], (float)hsb[2]);
                    this.waypoint.color = col.rgba();
                    this.waypoint.dimension.saveData = true;
                    this.icon = Color4I.EMPTY;
                    this.outsideIcon = Color4I.EMPTY;
                    this.checkIcon();
                    ((ContextMenuItem)contextMenu.get((int)0)).icon = this.icon;
                }).setCloseMenu(false));
            }
            contextMenu.add(new ContextMenuItem((Component)Component.m_237113_((String)(this.waypoint.hidden ? "Show" : "Hide")), Icons.BEACON, () -> {
                this.waypoint.hidden = !this.waypoint.hidden;
                this.waypoint.dimension.saveData = true;
                ((ContextMenuItem)contextMenu.get((int)0)).title = Component.m_237113_((String)(this.waypoint.hidden ? "Show" : "Hide"));
                screen.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"gui.remove"), Icons.REMOVE, () -> {
                this.waypoint.dimension.getWaypointManager().remove(this.waypoint);
                screen.regionPanel.refreshWidgets();
            }));
            screen.openContextMenu(contextMenu);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(LargeMapScreen screen, Key key) {
        if (super.keyPressed(screen, key)) {
            return true;
        }
        if (key.is(261)) {
            this.waypoint.dimension.getWaypointManager().remove(this.waypoint);
            screen.regionPanel.refreshWidgets();
            return true;
        }
        return false;
    }

    public void checkIcon() {
        if (this.icon == Color4I.EMPTY || this.outsideIcon == Color4I.EMPTY) {
            Color4I tint = Color4I.rgb((int)this.waypoint.color).withAlpha(this.waypoint.hidden ? 130 : 255);
            this.icon = this.waypoint.type.icon.withTint(tint);
            this.outsideIcon = this.waypoint.type.outsideIcon.withTint(tint);
        }
    }

    @Override
    public void draw(MapType mapType, PoseStack stack, int x, int y, int w, int h, boolean outsideVisibleArea, int iconAlpha) {
        Icon toDraw;
        this.checkIcon();
        Icon icon = toDraw = outsideVisibleArea || mapType.isWorldIcon() ? this.outsideIcon : this.icon;
        if (iconAlpha < 255 && toDraw instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)toDraw;
            img.withColor(img.color.withAlpha(iconAlpha)).draw(stack, x, y, w, h);
        } else {
            toDraw.draw(stack, x, y, w, h);
        }
        if (!outsideVisibleArea && mapType.isWorldIcon()) {
            Minecraft mc = Minecraft.m_91087_();
            String ds = Mth.m_14165_((double)MathUtils.dist((double)this.pos.f_82479_, (double)this.pos.f_82480_, (double)this.pos.f_82481_, (double)mc.f_91074_.m_20185_(), (double)mc.f_91074_.m_20186_(), (double)mc.f_91074_.m_20189_())) + " m";
            int nw = mc.f_91062_.m_92895_(this.waypoint.name);
            int dw = mc.f_91062_.m_92895_(ds);
            Color4I.DARK_GRAY.withAlpha(200).draw(stack, x + (w - nw) / 2 - 2, y - 14, nw + 4, 12);
            Color4I.DARK_GRAY.withAlpha(200).draw(stack, x + (w - dw) / 2 - 2, y + 18, dw + 4, 12);
            mc.f_91062_.m_92750_(stack, this.waypoint.name, (float)x + (float)(w - nw) / 2.0f, (float)y - 12.0f, -1);
            mc.f_91062_.m_92750_(stack, ds, (float)x + (float)(w - dw) / 2.0f, (float)y + 20.0f, -1);
            RenderSystem.m_69478_();
            RenderSystem.m_69482_();
        }
    }
}

