/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.breeches.screw_breech;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.content.kinetics.base.HalfShaftInstance;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.screw_breech.ScrewBreechBlockEntity;

public class ScrewBreechInstance
extends HalfShaftInstance<ScrewBreechBlockEntity>
implements DynamicInstance {
    private final ScrewBreechBlockEntity breech;
    private OrientedData screwLock;
    private Direction facing;

    public ScrewBreechInstance(MaterialManager modelManager, ScrewBreechBlockEntity tile) {
        super(modelManager, (KineticBlockEntity)tile);
        this.breech = tile;
    }

    public void init() {
        super.init();
        this.facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.screwLock = (OrientedData)this.materialManager.defaultSolid().material(Materials.ORIENTED).getModel(CBCClientCommon.getScrewBreechForState(this.blockState), this.blockState, this.facing).createInstance();
        this.transformModels();
    }

    private void transformModels() {
        float renderedScrewLockOffset = this.breech.getRenderedBlockOffset(AnimationTickHolder.getPartialTicks());
        float heightOffset = renderedScrewLockOffset * 0.25f;
        float rotationOffset = renderedScrewLockOffset * (this.facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 360.0f : -360.0f);
        Vector3f normal = this.facing.m_122432_();
        Vector3f height = normal.m_122281_();
        height.m_122261_(heightOffset);
        Quaternion q = normal.m_122240_(rotationOffset);
        this.screwLock.setPosition(this.getInstancePosition()).nudge(height.m_122239_(), height.m_122260_(), height.m_122269_()).setRotation(q);
    }

    public void beginFrame() {
        this.transformModels();
    }

    public void remove() {
        super.remove();
        this.screwLock.delete();
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.screwLock});
    }
}

