/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.assets;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.cannon_control.carriage.CannonCarriageBlock;
import rbasamoyai.createbigcannons.cannon_control.carriage.CannonCarriageBlockItem;
import rbasamoyai.createbigcannons.cannon_loading.CannonLoaderGen;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBarrelBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlockItem;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AutocannonBreechBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlockItem;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.sliding_breech.SlidingBreechBlockGen;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillGen;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderGen;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderHeadBlock;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastMouldBlock;
import rbasamoyai.createbigcannons.crafting.incomplete.IncompleteScrewBreechBlockGen;
import rbasamoyai.createbigcannons.crafting.incomplete.IncompleteSlidingBreechBlockGen;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerBlock;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerItem;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlockItem;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class CBCBuilderTransformers {
    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonBarrel(String material, boolean bored) {
        NonNullUnaryOperator b1 = CBCBuilderTransformers.cannonPart(CreateBigCannons.resource("block/cannon_barrel"), "cannon_barrel/" + material + "_cannon_barrel_side", "cannon_barrel/" + (bored ? "" : "unbored_") + material + "_cannon_barrel_end");
        return bored ? b1.andThen(b -> b.tag(new TagKey[]{CBCTags.CBCBlockTags.REDUCES_SPREAD})) : b1;
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> builtUpCannonBarrel(String material, boolean bored) {
        NonNullUnaryOperator b1 = CBCBuilderTransformers.cannonPart(CreateBigCannons.resource("block/built_up_cannon_barrel"), "cannon_barrel/built_up_" + material + "_cannon_barrel_side", "cannon_barrel/" + (bored ? "" : "unbored_") + "built_up_" + material + "_cannon_barrel_end");
        return bored ? b1.andThen(b -> b.tag(new TagKey[]{CBCTags.CBCBlockTags.REDUCES_SPREAD})) : b1;
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonChamber(String material, boolean bored) {
        NonNullUnaryOperator b1 = CBCBuilderTransformers.cannonPart(CBCUtils.location("block/cube_column"), "cannon_chamber/" + material + "_cannon_chamber_side", "cannon_chamber/" + (bored ? "" : "unbored_") + material + "_cannon_chamber_end");
        return bored ? b1.andThen(b -> b.tag(new TagKey[]{CBCTags.CBCBlockTags.THICK_TUBING}).tag(new TagKey[]{CBCTags.CBCBlockTags.REDUCES_SPREAD})) : b1;
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> builtUpCannonChamber(String material, boolean bored) {
        NonNullUnaryOperator b1 = CBCBuilderTransformers.cannonPart(CreateBigCannons.resource("block/built_up_cannon_chamber"), "cannon_chamber/built_up_" + material + "_cannon_chamber_side", "cannon_chamber/" + (bored ? "" : "unbored_") + "built_up_" + material + "_cannon_chamber_end");
        return bored ? b1.andThen(b -> b.tag(new TagKey[]{CBCTags.CBCBlockTags.THICK_TUBING}).tag(new TagKey[]{CBCTags.CBCBlockTags.REDUCES_SPREAD})) : b1;
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> thickCannonChamber(String material, boolean bored) {
        NonNullUnaryOperator b1 = CBCBuilderTransformers.cannonPart(CreateBigCannons.resource("block/thick_cannon_chamber"), "cannon_chamber/thick_" + material + "_cannon_chamber_side", "cannon_chamber/" + (bored ? "" : "unbored_") + "thick_" + material + "_cannon_chamber_end");
        return bored ? b1.andThen(b -> b.tag(new TagKey[]{CBCTags.CBCBlockTags.THICK_TUBING}).tag(new TagKey[]{CBCTags.CBCBlockTags.REDUCES_SPREAD})) : b1;
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonPart(ResourceLocation model, String side, String end) {
        ResourceLocation sideLoc = CreateBigCannons.resource("block/" + side);
        ResourceLocation endLoc = CreateBigCannons.resource("block/" + end);
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), model)).texture("side", sideLoc)).texture("end", endLoc)).texture("particle", sideLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> sizedHollowCannon(String sizePath, String pathAndMaterial) {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/" + sizePath + "_cannon_tube");
        ResourceLocation tubeLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_tube");
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseLoc)).texture("tube", tubeLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonEnd(String pathAndMaterial) {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/cannon_end");
        ResourceLocation sideLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_end_side");
        ResourceLocation topLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_end_top");
        ResourceLocation bottomLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_end_bottom");
        ResourceLocation knobLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_end_knob");
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseLoc)).texture("side", sideLoc)).texture("top", topLoc)).texture("bottom", bottomLoc)).texture("knob", knobLoc)).texture("particle", topLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> dropMortarEnd(String pathAndMaterial) {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/drop_mortar_end");
        ResourceLocation sideLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_end_side");
        ResourceLocation topLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_end_top");
        ResourceLocation bottomLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_end_bottom");
        ResourceLocation knobLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_cannon_end_knob");
        ResourceLocation spikeLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_drop_mortar_end_spike");
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseLoc)).texture("spike", spikeLoc)).texture("side", sideLoc)).texture("top", topLoc)).texture("bottom", bottomLoc)).texture("knob", knobLoc)).texture("particle", topLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> slidingBreech(String pathAndMaterial) {
        ResourceLocation itemBaseLoc = CreateBigCannons.resource("block/sliding_breech_item");
        ResourceLocation holeLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_hole");
        ResourceLocation sideLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_side");
        ResourceLocation sideHoleLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_side_hole");
        ResourceLocation insideLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_inside");
        ResourceLocation breechblockTopLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_breechblock_top");
        ResourceLocation breechblockEndLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_breechblock_end");
        ResourceLocation breechblockSideLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_breechblock_side");
        ResourceLocation breechblockBottomLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_breechblock_bottom");
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((arg_0, arg_1) -> ((SlidingBreechBlockGen)new SlidingBreechBlockGen(pathAndMaterial)).generate(arg_0, arg_1)).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item((x$0, x$1) -> new BigCannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)p.getExistingFile(itemBaseLoc))).texture("hole", holeLoc)).texture("side", sideLoc)).texture("side_hole", sideHoleLoc)).texture("inside", insideLoc)).texture("breechblock_top", breechblockTopLoc)).texture("breechblock_end", breechblockEndLoc)).texture("breechblock_side", breechblockSideLoc)).texture("breechblock_bottom", breechblockBottomLoc)).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> slidingBreechUnbored(String pathAndMaterial) {
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((arg_0, arg_1) -> ((SlidingBreechBlockGen)new SlidingBreechBlockGen(pathAndMaterial)).generate(arg_0, arg_1)).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> slidingBreechIncomplete(String pathAndMaterial) {
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((arg_0, arg_1) -> ((IncompleteSlidingBreechBlockGen)new IncompleteSlidingBreechBlockGen(pathAndMaterial)).generate(arg_0, arg_1)).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> screwBreech(String pathAndMaterial) {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/screw_breech");
        ResourceLocation itemBaseLoc = CreateBigCannons.resource("block/screw_breech_item");
        ResourceLocation topLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_screw_breech_top");
        ResourceLocation bottomLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_screw_breech_bottom");
        ResourceLocation sideLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_screw_breech_side");
        ResourceLocation lockLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_screw_lock");
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseLoc)).texture("side", sideLoc)).texture("top", topLoc)).texture("bottom", bottomLoc)).texture("particle", topLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item((x$0, x$1) -> new BigCannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)p.getExistingFile(itemBaseLoc))).texture("side", sideLoc)).texture("top", topLoc)).texture("bottom", bottomLoc)).texture("lock", lockLoc)).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> screwBreechUnbored(String pathAndMaterial, String typePathAndMaterial) {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/screw_breech");
        ResourceLocation itemBaseLoc = CreateBigCannons.resource("block/screw_breech_item");
        ResourceLocation topLoc = CreateBigCannons.resource("block/" + typePathAndMaterial + "_screw_breech_top");
        ResourceLocation bottomLoc = CreateBigCannons.resource("block/" + typePathAndMaterial + "_screw_breech_bottom");
        ResourceLocation sideLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_screw_breech_side");
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseLoc)).texture("side", sideLoc)).texture("top", topLoc)).texture("bottom", bottomLoc)).texture("particle", topLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item((x$0, x$1) -> new BigCannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)p.getExistingFile(itemBaseLoc))).texture("side", sideLoc)).texture("top", topLoc)).texture("bottom", bottomLoc)).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> screwBreechIncomplete(String pathAndMaterial) {
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((arg_0, arg_1) -> ((IncompleteScrewBreechBlockGen)new IncompleteScrewBreechBlockGen(pathAndMaterial)).generate(arg_0, arg_1)).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
    }

    public static <T extends Item, P> NonNullUnaryOperator<ItemBuilder<T, P>> screwLock(String pathAndMaterial) {
        ResourceLocation baseLoc = CreateBigCannons.resource("item/screw_lock");
        ResourceLocation lockLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_screw_lock");
        return b -> b.model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)p.getExistingFile(baseLoc))).texture("lock", lockLoc));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> autocannonBarrel(String pathAndMaterial) {
        ResourceLocation texLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon");
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> BlockStateGen.directionalBlockIgnoresWaterlogged((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> {
            String name = c.getName() + "_" + ((Boolean)s.m_61143_((Property)AutocannonBarrelBlock.ASSEMBLED) != false ? "assembled" : ((AutocannonBarrelBlock.AutocannonBarrelEnd)((Object)((Object)((Object)((Object)s.m_61143_(AutocannonBarrelBlock.BARREL_END)))))).m_7912_());
            if (((Boolean)s.m_61143_((Property)AutocannonBarrelBlock.ASSEMBLED)).booleanValue()) {
                return ((BlockModelBuilder)p.models().getBuilder(name)).texture("particle", texLoc);
            }
            ResourceLocation loc = switch ((AutocannonBarrelBlock.AutocannonBarrelEnd)((Object)((Object)((Object)((Object)s.m_61143_(AutocannonBarrelBlock.BARREL_END)))))) {
                case AutocannonBarrelBlock.AutocannonBarrelEnd.FLANGED -> CreateBigCannons.resource("block/autocannon/barrel_flanged");
                default -> CreateBigCannons.resource("block/autocannon/barrel");
            };
            return ((BlockModelBuilder)p.models().withExistingParent(name, loc)).texture("material", texLoc);
        })).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item((x$0, x$1) -> new AutocannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> ((ItemModelBuilder)p.withExistingParent(c.getName(), CreateBigCannons.resource("block/autocannon/barrel"))).texture("material", texLoc)).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> autocannonBreech(String pathAndMaterial, boolean complete) {
        ResourceLocation texLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon");
        ResourceLocation tex1Loc = CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon_1");
        ResourceLocation baseLoc = CreateBigCannons.resource("block/autocannon/breech");
        ResourceLocation handleLoc = CreateBigCannons.resource("block/autocannon/breech_handle");
        NonNullUnaryOperator result = b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> BlockStateGen.directionalBlockIgnoresWaterlogged((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> {
            boolean handle = s.m_61138_((Property)AutocannonBreechBlock.HANDLE) && (Boolean)s.m_61143_((Property)AutocannonBreechBlock.HANDLE) != false;
            return ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent((String)(handle ? c.getName() + "_handle" : c.getName()), handle ? handleLoc : baseLoc)).texture("material", texLoc)).texture("handle", tex1Loc);
        })).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
        result = complete ? result.andThen(b -> (BlockBuilder)b.item((x$0, x$1) -> new AutocannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> ((ItemModelBuilder)p.withExistingParent(c.getName(), CreateBigCannons.resource("block/autocannon/breech_item"))).texture("material", texLoc)).build()) : result.andThen(b -> (BlockBuilder)b.item((x$0, x$1) -> new AutocannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> p.blockItem((NonNullSupplier)c)).build());
        return result;
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> autocannonRecoilSpring(String pathAndMaterial, boolean complete) {
        ResourceLocation texLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon");
        NonNullUnaryOperator result = b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> BlockStateGen.directionalBlockIgnoresWaterlogged((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> ((BlockModelBuilder)p.models().withExistingParent(c.getName(), CreateBigCannons.resource("block/autocannon/recoil_spring"))).texture("material", texLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
        result = complete ? result.andThen(b -> (BlockBuilder)b.item((x$0, x$1) -> new AutocannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> ((ItemModelBuilder)p.withExistingParent(c.getName(), CreateBigCannons.resource("block/autocannon/recoil_spring_item"))).texture("material", texLoc)).build()) : result.andThen(b -> (BlockBuilder)b.item((x$0, x$1) -> new AutocannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> p.blockItem((NonNullSupplier)c)).build());
        return result;
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> unboredAutocannonBarrel(String pathAndMaterial) {
        return CBCBuilderTransformers.unboredAutocannonBlock(CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon"), CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon_1"), CreateBigCannons.resource("block/autocannon/unbored_barrel"));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> unboredAutocannonRecoilSpring(String pathAndMaterial) {
        return CBCBuilderTransformers.unboredAutocannonBlock(CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon"), CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon_1"), CreateBigCannons.resource("block/autocannon/unbored_recoil_spring"));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> unboredAutocannonBreech(String pathAndMaterial) {
        return CBCBuilderTransformers.unboredAutocannonBlock(CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon"), CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon_1"), CreateBigCannons.resource("block/autocannon/unbored_breech"));
    }

    private static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> unboredAutocannonBlock(ResourceLocation tex, ResourceLocation tex1, ResourceLocation model) {
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> BlockStateGen.directionalBlockIgnoresWaterlogged((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), model)).texture("material", tex)).texture("material1", tex1))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item((x$0, x$1) -> new AutocannonBlockItem<Block>((Block)x$0, (Item.Properties)x$1)).model((c, p) -> p.blockItem((NonNullSupplier)c)).build();
    }

    public static <T extends Item, P> NonNullUnaryOperator<ItemBuilder<T, P>> autocannonBreechExtractor(String pathAndMaterial) {
        return b -> b.model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)p.getExistingFile(CreateBigCannons.resource("block/autocannon/extractor")))).texture("material", CreateBigCannons.resource("block/" + pathAndMaterial + "_autocannon")));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> ramHead() {
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate(BlockStateGen.directionalBlockProvider((boolean)false));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> wormHead() {
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate(BlockStateGen.directionalBlockProvider((boolean)false));
    }

    public static <T extends DirectionalAxisKineticBlock, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonLoader() {
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((arg_0, arg_1) -> ((CannonLoaderGen)new CannonLoaderGen()).generate(arg_0, arg_1)).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item().model((c, p) -> {}).build();
    }

    public static <T extends DirectionalAxisKineticBlock, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonDrill() {
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((arg_0, arg_1) -> ((CannonDrillGen)new CannonDrillGen()).generate(arg_0, arg_1)).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item().model((c, p) -> {}).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonDrillBit() {
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).loot((t, p) -> t.m_124147_(p, (ItemLike)AllBlocks.PISTON_EXTENSION_POLE.get())).blockstate(BlockStateGen.directionalBlockProvider((boolean)false));
    }

    public static <T extends DirectionalAxisKineticBlock, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonBuilder() {
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((arg_0, arg_1) -> ((CannonBuilderGen)new CannonBuilderGen()).generate(arg_0, arg_1)).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item().model((c, p) -> {}).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonBuilderHead() {
        ResourceLocation notAttachedLoc = CreateBigCannons.resource("block/cannon_builder/cannon_builder_head");
        ResourceLocation attachedLoc = CreateBigCannons.resource("block/cannon_builder/cannon_builder_head_attached");
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).loot((t, p) -> t.m_124147_(p, (ItemLike)AllBlocks.PISTON_EXTENSION_POLE.get())).blockstate((c, p) -> BlockStateGen.directionalBlockIgnoresWaterlogged((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile((Boolean)s.m_61143_((Property)CannonBuilderHeadBlock.ATTACHED) != false ? attachedLoc : notAttachedLoc)));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> projectileLegacy(String pathAndMaterial) {
        return CBCBuilderTransformers.projectile(pathAndMaterial, true);
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> projectile(String pathAndMaterial) {
        return CBCBuilderTransformers.projectile(pathAndMaterial, false);
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> projectile(String pathAndMaterial, boolean useStandardModel) {
        ResourceLocation baseLoc = CreateBigCannons.resource(String.format("block/%sprojectile_block", useStandardModel ? "standard_" : ""));
        ResourceLocation sideLoc = CreateBigCannons.resource("block/" + pathAndMaterial);
        ResourceLocation topLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_top");
        ResourceLocation bottomLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_bottom");
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110451_).blockstate((c, p) -> {
            BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseLoc)).texture("side", sideLoc)).texture("top", topLoc)).texture("particle", topLoc);
            if (!useStandardModel) {
                builder.texture("bottom", bottomLoc);
            }
            p.directionalBlock((Block)c.get(), (ModelFile)builder);
        });
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> powderCharge() {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/powder_charge");
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110451_).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, $ -> p.models().getExistingFile(baseLoc)));
    }

    public static <T extends BigCartridgeBlock, P> NonNullUnaryOperator<BlockBuilder<T, P>> bigCartridge() {
        ResourceLocation filledLoc = CreateBigCannons.resource("block/big_cartridge_filled");
        ResourceLocation emptyLoc = CreateBigCannons.resource("block/big_cartridge_empty");
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110451_).blockstate((c, p) -> BlockStateGen.directionalBlockIgnoresWaterlogged((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile((Boolean)s.m_61143_((Property)BigCartridgeBlock.FILLED) != false ? filledLoc : emptyLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).loot((t, c) -> t.m_124165_((Block)c, LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLoot.m_236224_((ItemLike)c, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)c)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Power", "Power")))))).item((x$0, x$1) -> new BigCartridgeBlockItem((BigCartridgeBlock)x$0, (Item.Properties)x$1)).tag(new TagKey[]{CBCTags.CBCItemTags.BIG_CANNON_CARTRIDGES}).model((c, p) -> ((ItemModelBuilder)p.withExistingParent(c.getName(), emptyLoc)).override().model((ModelFile)p.getExistingFile(filledLoc)).predicate(CreateBigCannons.resource("big_cartridge_filled"), 1.0f).end()).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> autocannonAmmoContainer(boolean isCreative) {
        String root = isCreative ? "creative" : "regular";
        return b -> (BlockBuilder)b.addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> {
            AutocannonAmmoContainerBlock.State containerState = (AutocannonAmmoContainerBlock.State)((Object)((Object)((Object)((Object)state.m_61143_(AutocannonAmmoContainerBlock.CONTAINER_STATE)))));
            String suffix = switch (containerState) {
                default -> throw new IncompatibleClassChangeError();
                case AutocannonAmmoContainerBlock.State.CLOSED -> "";
                case AutocannonAmmoContainerBlock.State.EMPTY -> "_empty";
                case AutocannonAmmoContainerBlock.State.FILLED -> "_filled";
            };
            ResourceLocation loc = p.modLoc("block/autocannon_ammo_containers/" + root + suffix);
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(loc)).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
        }, new Property[]{BlockStateProperties.f_61362_})).loot((t, c) -> {
            CopyNbtFunction.Builder func = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Ammo", "Ammo").m_80279_("Tracers", "Tracers").m_80279_("TracerSpacing", "TracerSpacing");
            if (isCreative) {
                func = func.m_80279_("CurrentIndex", "CurrentIndex");
            }
            t.m_124165_(c, LootTable.m_79147_().m_79161_(((LootPool.Builder)BlockLoot.m_236224_((ItemLike)c, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)c)).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)))).m_79078_((LootItemFunction.Builder)func)));
        }).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item(AutocannonAmmoContainerItem::new).properties(p -> p.m_41487_(1)).properties(p -> isCreative ? p.m_41497_(Rarity.EPIC) : p).tag(new TagKey[]{CBCTags.CBCItemTags.AUTOCANNON_AMMO_CONTAINERS}).model((c, p) -> p.withExistingParent(c.getName(), p.modLoc("block/autocannon_ammo_containers/" + root))).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonMount() {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/cannon_mount/cannon_mount");
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(baseLoc), 0)).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item().model((c, p) -> {}).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> yawController() {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/cannon_mount/yaw_controller");
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(baseLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).item().model((c, p) -> {}).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> cannonCarriage() {
        ResourceLocation blockLoc = CreateBigCannons.resource("block/cannon_carriage/block");
        ResourceLocation saddleLoc = CreateBigCannons.resource("block/cannon_carriage/block_saddle");
        return b -> (BlockBuilder)b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), s -> p.models().getExistingFile((Boolean)s.m_61143_((Property)CannonCarriageBlock.SADDLED) != false ? saddleLoc : blockLoc))).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).loot((t, u) -> t.m_124165_(u, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)BlockLoot.m_236221_((ItemLike)u, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)u)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)BlockLoot.m_236221_((ItemLike)u, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42450_))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)u).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)CannonCarriageBlock.SADDLED, true)))))).item(CannonCarriageBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)p.getExistingFile(blockLoc))).build();
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> invisibleWithParticle(String path) {
        return b -> b.properties(p -> p.m_60955_()).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)p.models().getBuilder(c.getName())).texture("particle", CreateBigCannons.resource(path))));
    }

    public static <T extends Item, P> NonNullUnaryOperator<ItemBuilder<T, P>> slidingBreechblock(String pathAndMaterial) {
        ResourceLocation baseLoc = CreateBigCannons.resource("item/sliding_breechblock");
        ResourceLocation topLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_breechblock_top");
        ResourceLocation endLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_breechblock_end");
        ResourceLocation sideLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_breechblock_side");
        ResourceLocation bottomLoc = CreateBigCannons.resource("block/" + pathAndMaterial + "_sliding_breech_breechblock_bottom");
        return b -> b.model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)p.getExistingFile(baseLoc))).texture("top", topLoc)).texture("end", endLoc)).texture("side", sideLoc)).texture("bottom", bottomLoc));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> castMould(String size) {
        ResourceLocation baseLoc = CreateBigCannons.resource("block/cast_mould/" + size + "_cast_mould");
        ResourceLocation sandLoc = CreateBigCannons.resource("block/casting_sand");
        return b -> (BlockBuilder)b.initialProperties(Material.f_76320_, MaterialColor.f_76370_).properties(p -> p.m_60913_(2.0f, 3.0f)).properties(p -> p.m_60918_(SoundType.f_56736_)).properties(p -> p.m_60955_()).tag(new TagKey[]{BlockTags.f_144280_}).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).addLayer(() -> RenderType::m_110451_).blockstate((c, p) -> ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)p.getMultipartBuilder((Block)c.get()).part().modelFile((ModelFile)p.models().getExistingFile(baseLoc)).addModel()).end().part().modelFile((ModelFile)p.models().getExistingFile(sandLoc)).addModel()).condition((Property)CannonCastMouldBlock.SAND, (Comparable[])new Boolean[]{true}).end()).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)p.getExistingFile(baseLoc))).build();
    }

    public static <T extends Block> NonNullBiConsumer<RegistrateBlockLootTables, T> castIronScrapLoot(int count) {
        return (t, u) -> t.m_124165_(u, BlockLoot.m_176042_((Block)u, (ItemLike)((ItemLike)CBCItems.CAST_IRON_NUGGET.get()), (NumberProvider)ConstantValue.m_165692_((float)count)));
    }

    public static <T extends Block> NonNullBiConsumer<RegistrateBlockLootTables, T> bronzeScrapLoot(int count) {
        return (t, u) -> t.m_124165_(u, BlockLoot.m_176042_((Block)u, (ItemLike)((ItemLike)CBCItems.BRONZE_SCRAP.get()), (NumberProvider)ConstantValue.m_165692_((float)count)));
    }

    public static <T extends Block> NonNullBiConsumer<RegistrateBlockLootTables, T> steelScrapLoot(int count) {
        return (t, u) -> t.m_124165_(u, BlockLoot.m_176042_((Block)u, (ItemLike)((ItemLike)CBCItems.STEEL_SCRAP.get()), (NumberProvider)ConstantValue.m_165692_((float)count)));
    }

    public static <T extends Block> NonNullBiConsumer<RegistrateBlockLootTables, T> nethersteelScrapLoot(int count) {
        return (t, u) -> t.m_124165_(u, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)CBCItems.NETHERSTEEL_NUGGET.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count))))));
    }

    public static <T extends Block> NonNullBiConsumer<RegistrateBlockLootTables, T> tracerProjectileLoot() {
        return CBCBuilderTransformers.tracerProjectileLoot((NonNullFunction<CopyNbtFunction.Builder, CopyNbtFunction.Builder>)((NonNullFunction)t -> t));
    }

    public static <T extends Block> NonNullBiConsumer<RegistrateBlockLootTables, T> tracerProjectileLoot(NonNullFunction<CopyNbtFunction.Builder, CopyNbtFunction.Builder> additionalCopyData) {
        return (t, u) -> t.m_124165_(u, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)u).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)additionalCopyData.apply((Object)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Tracer", "BlockEntityTag.Tracer").m_80279_("id", "BlockEntityTag.id"))))));
    }

    public static <T extends Block> NonNullBiConsumer<RegistrateBlockLootTables, T> shellLoot(NonNullFunction<CopyNbtFunction.Builder, CopyNbtFunction.Builder> additionalCopyData) {
        return CBCBuilderTransformers.tracerProjectileLoot((NonNullFunction<CopyNbtFunction.Builder, CopyNbtFunction.Builder>)((NonNullFunction)f -> ((CopyNbtFunction.Builder)additionalCopyData.apply(f)).m_80279_("Fuze", "BlockEntityTag.Fuze")));
    }

    public static <T extends Block> NonNullBiConsumer<RegistrateBlockLootTables, T> shellLoot() {
        return CBCBuilderTransformers.shellLoot((NonNullFunction<CopyNbtFunction.Builder, CopyNbtFunction.Builder>)((NonNullFunction)t -> t));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> dropMortarShell() {
        return b -> b.properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110463_).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(CreateBigCannons.resource("block/drop_mortar_shell"))));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> safeNbt() {
        return b -> b.tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag});
    }
}

