/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.sounds;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;

public class ShellFlyingSoundInstance
extends AbstractTickableSoundInstance {
    private final LocalPlayer player;
    private final AbstractCannonProjectile entity;
    private double radius;
    private int time;
    private int timeout;
    private float basePitch;

    public ShellFlyingSoundInstance(SoundEvent event, RandomSource randomSource, LocalPlayer player, AbstractCannonProjectile entity, double radius) {
        super(event, SoundSource.NEUTRAL, randomSource);
        this.player = player;
        this.entity = entity;
        this.radius = radius;
        this.f_119578_ = true;
        Vec3 pos = this.entity.m_20182_();
        Vec3 shellVelocity = this.entity.m_20184_();
        double wakeLength = Math.min(shellVelocity.m_82556_(), 100.0);
        Vec3 soundPos = pos.m_82546_(shellVelocity.m_82541_().m_82490_(wakeLength));
        this.f_119575_ = (float)soundPos.f_82479_;
        this.f_119576_ = (float)soundPos.f_82480_;
        this.f_119577_ = (float)soundPos.f_82481_;
        this.basePitch = 0.95f + this.entity.f_19853_.f_46441_.m_188501_() * 0.3f;
    }

    public void m_7788_() {
        ++this.time;
        int FADE_IN_TIME = 1;
        int FADE_OUT_TIME = 20;
        if (!this.player.m_213877_() && !this.entity.m_213877_() && this.entity.getLocalSoundCooldown() <= 0) {
            double intensity;
            Vec3 pos = this.entity.m_20182_();
            Vec3 shellVelocity = this.entity.m_20184_();
            Vec3 playerDir = this.player.m_20182_().m_82546_(pos);
            float alignment = (float)shellVelocity.m_82541_().m_82526_(playerDir.m_82541_());
            double wakeLength = Math.min(shellVelocity.m_82556_(), 100.0);
            Vec3 soundPos = pos.m_82546_(shellVelocity.m_82541_().m_82490_(wakeLength));
            this.f_119575_ = (float)soundPos.f_82479_;
            this.f_119576_ = (float)soundPos.f_82480_;
            this.f_119577_ = (float)soundPos.f_82481_;
            float velSqr = (float)shellVelocity.m_82556_();
            this.f_119573_ = velSqr >= 1.0E-4f ? Mth.m_14036_((float)(velSqr / 4.0f), (float)0.0f, (float)1.0f) : 0.0f;
            if (this.time < FADE_IN_TIME) {
                this.f_119573_ *= (float)this.time / (float)FADE_IN_TIME;
            }
            if ((intensity = 1.0 - this.player.m_20238_(soundPos) / this.radius / this.radius) < 1.0) {
                this.f_119573_ *= (float)intensity;
            }
            float pitchShift = Math.min(velSqr / 25.0f, 1.0f) * alignment;
            this.f_119574_ = Mth.m_14036_((float)(this.basePitch + pitchShift), (float)0.0f, (float)2.0f);
            if (intensity <= 0.0 || (double)alignment < -0.5) {
                ++this.timeout;
            } else if (this.timeout > 0) {
                --this.timeout;
            }
        } else {
            this.timeout = FADE_OUT_TIME;
            this.f_119573_ = 0.0f;
        }
        this.f_119573_ *= Mth.m_14036_((float)(1.0f - (float)this.timeout / (float)FADE_OUT_TIME), (float)0.0f, (float)1.0f);
        if (this.timeout >= FADE_OUT_TIME) {
            this.m_119609_();
            this.entity.setLocalSoundCooldown(3);
        }
    }
}

