/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon.ammo_container;

import com.simibubi.create.foundation.utility.Components;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCMenuTypes;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerMenu;

public class AutocannonAmmoContainerItem
extends BlockItem
implements MenuProvider {
    public AutocannonAmmoContainerItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public Component m_5446_() {
        return this.m_41466_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return AutocannonAmmoContainerMenu.getServerMenuForItemStack(i, inventory, player.m_21205_(), this.isCreative());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_36326_()) {
            ItemStack stack = player.m_21120_(hand);
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                int spacing = AutocannonAmmoContainerItem.getTracerSpacing(stack);
                Component screenName = stack.m_41788_() ? stack.m_41786_() : this.m_5446_();
                CBCMenuTypes.AUTOCANNON_AMMO_CONTAINER.open(splayer, screenName, (MenuConstructor)this, buf -> {
                    buf.writeBoolean(this.isCreative());
                    buf.m_130130_(spacing);
                    buf.writeBoolean(false);
                    buf.m_130055_(new ItemStack((ItemLike)this));
                });
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult superResult = super.m_6225_(context);
        if (superResult.m_19077_()) {
            return superResult;
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    public static ItemStack getMainAmmoStack(ItemStack container) {
        CompoundTag tag = container.m_41784_();
        return tag.m_128441_("Ammo") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Ammo")) : ItemStack.f_41583_;
    }

    public static ItemStack getTracerAmmoStack(ItemStack container) {
        CompoundTag tag = container.m_41784_();
        return tag.m_128441_("Tracers") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Tracers")) : ItemStack.f_41583_;
    }

    public static int getTracerSpacing(ItemStack container) {
        CompoundTag tag = container.m_41784_();
        return tag.m_128441_("TracerSpacing") ? Mth.m_14045_((int)tag.m_128451_("TracerSpacing"), (int)1, (int)6) : 1;
    }

    public static boolean shouldPullTracer(ItemStack container) {
        int currentCount;
        CompoundTag tag = container.m_41784_();
        if (!tag.m_128425_("CurrentIndex", 3)) {
            tag.m_128405_("CurrentIndex", 0);
        }
        tag.m_128405_("CurrentIndex", (currentCount = Math.max(tag.m_128451_("CurrentIndex"), 0)) >= AutocannonAmmoContainerItem.getTracerSpacing(container) ? 0 : currentCount + 1);
        return currentCount == 0;
    }

    public static AutocannonAmmoType getTypeOfContainer(ItemStack container) {
        AutocannonAmmoType type = AutocannonAmmoType.of(AutocannonAmmoContainerItem.getMainAmmoStack(container));
        if (type != AutocannonAmmoType.NONE) {
            return type;
        }
        return AutocannonAmmoType.of(AutocannonAmmoContainerItem.getTracerAmmoStack(container));
    }

    public static int getTotalAmmoCount(ItemStack container) {
        return AutocannonAmmoContainerItem.getMainAmmoStack(container).m_41613_() + AutocannonAmmoContainerItem.getTracerAmmoStack(container).m_41613_();
    }

    public static ItemStack pollItemFromContainer(ItemStack container) {
        Item item = container.m_41720_();
        if (!(item instanceof AutocannonAmmoContainerItem)) {
            return ItemStack.f_41583_;
        }
        AutocannonAmmoContainerItem ctItem = (AutocannonAmmoContainerItem)item;
        ItemStack mainAmmo = AutocannonAmmoContainerItem.getMainAmmoStack(container);
        ItemStack tracerAmmo = AutocannonAmmoContainerItem.getTracerAmmoStack(container);
        ItemStack ret = ItemStack.f_41583_;
        boolean isCreative = ctItem.isCreative();
        if (isCreative && AutocannonAmmoContainerItem.shouldPullTracer(container) || !isCreative && AutocannonAmmoContainerItem.getTotalAmmoCount(container) % AutocannonAmmoContainerItem.getTracerSpacing(container) == 0) {
            if (!tracerAmmo.m_41619_()) {
                if (isCreative) {
                    ret = tracerAmmo.m_41777_();
                    ret.m_41764_(1);
                } else {
                    ret = tracerAmmo.m_41620_(1);
                    container.m_41784_().m_128365_("Tracers", (Tag)(tracerAmmo.m_41619_() ? new CompoundTag() : tracerAmmo.m_41739_(new CompoundTag())));
                }
            } else if (!mainAmmo.m_41619_()) {
                if (isCreative) {
                    ret = mainAmmo.m_41777_();
                    ret.m_41764_(1);
                } else {
                    ret = mainAmmo.m_41620_(1);
                    container.m_41784_().m_128365_("Ammo", (Tag)(mainAmmo.m_41619_() ? new CompoundTag() : mainAmmo.m_41739_(new CompoundTag())));
                }
            }
        } else if (!mainAmmo.m_41619_()) {
            if (isCreative) {
                ret = mainAmmo.m_41777_();
                ret.m_41764_(1);
            } else {
                ret = mainAmmo.m_41620_(1);
                container.m_41784_().m_128365_("Ammo", (Tag)(mainAmmo.m_41619_() ? new CompoundTag() : mainAmmo.m_41739_(new CompoundTag())));
            }
        } else if (!tracerAmmo.m_41619_()) {
            if (isCreative) {
                ret = tracerAmmo.m_41777_();
                ret.m_41764_(1);
            } else {
                ret = tracerAmmo.m_41620_(1);
                container.m_41784_().m_128365_("Tracers", (Tag)(tracerAmmo.m_41619_() ? new CompoundTag() : tracerAmmo.m_41739_(new CompoundTag())));
            }
        }
        return ret;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        ItemStack tracerAmmo;
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        String infinity = "\u221e";
        ItemStack mainAmmo = AutocannonAmmoContainerItem.getMainAmmoStack(stack);
        if (!mainAmmo.m_41619_()) {
            String mainValue = this.isCreative() ? infinity : Integer.toString(mainAmmo.m_41613_());
            tooltipComponents.add((Component)Components.translatable((String)"block.createbigcannons.autocannon_ammo_container.tooltip.main_ammo", (Object[])new Object[]{mainValue, mainAmmo.m_41611_()}));
        }
        if (!(tracerAmmo = AutocannonAmmoContainerItem.getTracerAmmoStack(stack)).m_41619_()) {
            String tracerValue = this.isCreative() ? infinity : Integer.toString(tracerAmmo.m_41613_());
            tooltipComponents.add((Component)Components.translatable((String)"block.createbigcannons.autocannon_ammo_container.tooltip.tracers", (Object[])new Object[]{tracerValue, tracerAmmo.m_41611_()}));
        }
        int spacingValue = AutocannonAmmoContainerItem.getTracerSpacing(stack);
        tooltipComponents.add((Component)Components.translatable((String)"block.createbigcannons.autocannon_ammo_container.tooltip.tracer_spacing", (Object[])new Object[]{spacingValue}));
    }

    public boolean isCreative() {
        return CBCBlocks.CREATIVE_AUTOCANNON_AMMO_CONTAINER.is((Item)this);
    }
}

