/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon.flak;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile;
import rbasamoyai.createbigcannons.munitions.autocannon.flak.FlakAutocannonProjectileProperties;
import rbasamoyai.createbigcannons.munitions.autocannon.flak.FlakExplosion;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.config.components.EntityDamagePropertiesComponent;
import rbasamoyai.createbigcannons.munitions.fragment_burst.CBCProjectileBurst;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class FlakAutocannonProjectile
extends AbstractAutocannonProjectile {
    private ItemStack fuze = ItemStack.f_41583_;

    public FlakAutocannonProjectile(EntityType<? extends FlakAutocannonProjectile> type, Level level) {
        super((EntityType<? extends AbstractAutocannonProjectile>)type, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.canDetonate(fz -> fz.onProjectileTick(this.fuze, this))) {
            this.detonate((Position)this.m_20182_());
            this.removeNextTick = true;
        }
    }

    @Override
    protected void expireProjectile() {
        FuzeItem fuzeItem;
        Item item = this.fuze.m_41720_();
        if (item instanceof FuzeItem && (fuzeItem = (FuzeItem)item).onProjectileExpiry(this.fuze, this)) {
            this.detonate((Position)this.m_20182_());
        }
        super.expireProjectile();
    }

    @Override
    protected boolean onImpact(HitResult hitResult, AbstractCannonProjectile.ImpactResult impactResult, ProjectileContext projectileContext) {
        super.onImpact(hitResult, impactResult, projectileContext);
        if (this.canDetonate(fz -> fz.onProjectileImpact(this.fuze, this, hitResult, impactResult, false))) {
            this.detonate((Position)hitResult.m_82450_());
            return true;
        }
        return false;
    }

    @Override
    protected boolean onClip(ProjectileContext ctx, Vec3 start, Vec3 end) {
        if (super.onClip(ctx, start, end)) {
            return true;
        }
        if (this.canDetonate(fz -> fz.onProjectileClip(this.fuze, this, start, end, ctx, false))) {
            this.detonate((Position)start);
            return true;
        }
        return false;
    }

    protected void detonate(Position position) {
        Vec3 oldDelta = this.m_20184_();
        FlakAutocannonProjectileProperties properties = this.getAllProperties();
        FlakExplosion explosion = new FlakExplosion(this.f_19853_, null, this.indirectArtilleryFire(), position.m_7096_(), position.m_7098_(), position.m_7094_(), properties.explosion().explosivePower(), ((CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get())).explosiveInteraction());
        CreateBigCannons.handleCustomExplosion(this.f_19853_, explosion);
        CBCProjectileBurst.spawnConeBurst(this.f_19853_, (EntityType)CBCEntityTypes.FLAK_BURST.get(), new Vec3(position.m_7096_(), position.m_7098_(), position.m_7094_()), oldDelta, properties.flakBurst().burstProjectileCount(), properties.flakBurst().burstSpread());
    }

    public void setFuze(ItemStack fuze) {
        this.fuze = fuze;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.fuze != null && !this.fuze.m_41619_()) {
            tag.m_128365_("Fuze", (Tag)this.fuze.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.fuze = tag.m_128425_("Fuze", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Fuze")) : ItemStack.f_41583_;
    }

    protected final boolean canDetonate(Predicate<FuzeItem> cons) {
        FuzeItem fuzeItem;
        Item item;
        return !this.f_19853_.f_46443_ && this.f_19853_.m_46805_(this.m_20183_()) && !this.m_213877_() && (item = this.fuze.m_41720_()) instanceof FuzeItem && cons.test(fuzeItem = (FuzeItem)item);
    }

    @Override
    @Nonnull
    public EntityDamagePropertiesComponent getDamageProperties() {
        return this.getAllProperties().damage();
    }

    @Override
    @Nonnull
    protected BallisticPropertiesComponent getBallisticProperties() {
        return this.getAllProperties().ballistics();
    }

    protected FlakAutocannonProjectileProperties getAllProperties() {
        return (FlakAutocannonProjectileProperties)CBCMunitionPropertiesHandlers.FLAK_AUTOCANNON.getPropertiesOf((Entity)this);
    }
}

