/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import com.simibubi.create.AllFluids;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.effects.particles.explosions.FluidCloudParticleData;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.munitions.GasCloudEntity;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobBurst;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobEffectRegistry;

public class DefaultFluidCompat {
    public static void registerMinecraftBlobEffects() {
        FluidBlobEffectRegistry.registerHitEntity((Fluid)Fluids.f_76193_, DefaultFluidCompat::waterHitEntity);
        FluidBlobEffectRegistry.registerHitEntity((Fluid)Fluids.f_76195_, DefaultFluidCompat::lavaHitEntity);
        FluidBlobEffectRegistry.registerHitBlock((Fluid)Fluids.f_76193_, DefaultFluidCompat::waterHitBlock);
        FluidBlobEffectRegistry.registerHitBlock((Fluid)Fluids.f_76195_, DefaultFluidCompat::lavaHitBlock);
        FluidBlobEffectRegistry.registerFluidShellExplosionEffect((Fluid)Fluids.f_76193_, DefaultFluidCompat::waterFluidShellExplode);
        FluidBlobEffectRegistry.registerFluidShellExplosionEffect((Fluid)Fluids.f_76195_, DefaultFluidCompat::lavaFluidShellExplode);
    }

    public static void registerCreateBlobEffects() {
        FluidBlobEffectRegistry.registerHitBlock((Fluid)AllFluids.POTION.get(), DefaultFluidCompat::potionHitBlock);
        FluidBlobEffectRegistry.registerHitEntity((Fluid)AllFluids.POTION.get(), DefaultFluidCompat::potionHitEntity);
        FluidBlobEffectRegistry.registerFluidShellExplosionEffect((Fluid)AllFluids.POTION.get(), DefaultFluidCompat::potionFluidShellExplode);
    }

    public static void waterHitEntity(FluidBlobEffectRegistry.OnHitEntity.Context context) {
        Entity entity = context.result().m_82443_();
        entity.m_20095_();
    }

    public static void lavaHitEntity(FluidBlobEffectRegistry.OnHitEntity.Context context) {
        Entity entity = context.result().m_82443_();
        if (entity.m_5825_()) {
            return;
        }
        entity.m_20254_(10);
        if (entity.m_6469_(DamageSource.f_19307_, 4.0f)) {
            entity.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + entity.f_19853_.f_46441_.m_188501_() * 0.4f);
        }
    }

    public static void potionHitEntity(FluidBlobEffectRegistry.OnHitEntity.Context context) {
        Entity entity = context.result().m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        CompoundTag tag = context.burst().getFluidStack().data();
        for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)tag)) {
            living.m_7292_(new MobEffectInstance(effect));
        }
    }

    public static void waterHitBlock(FluidBlobEffectRegistry.OnHitBlock.Context context) {
        if (!context.level().f_46443_) {
            DefaultFluidCompat.douseFire(context.result().m_82425_().m_121945_(context.result().m_82434_()), context.burst(), context.level());
        }
    }

    public static void lavaHitBlock(FluidBlobEffectRegistry.OnHitBlock.Context context) {
        if (!context.level().f_46443_) {
            DefaultFluidCompat.spawnFire(context.result().m_82425_().m_121945_(context.result().m_82434_()), context.burst(), context.level());
        }
    }

    public static void potionHitBlock(FluidBlobEffectRegistry.OnHitBlock.Context context) {
        if (!context.level().f_46443_) {
            DefaultFluidCompat.spawnGasCloud(context.result().m_82425_().m_121945_(context.result().m_82434_()), context.burst(), context.level());
        }
    }

    public static void waterFluidShellExplode(FluidBlobEffectRegistry.OnFluidShellExplode.Context context) {
        Level level = context.level();
        double x = context.x();
        double y = context.y();
        double z = context.z();
        CBCSoundEvents.WATER_FLUID_RELEASE.playAt(level, x, y, z, 2.5f, 0.15f + level.f_46441_.m_188501_() * 0.3f, false);
        CBCSoundEvents.FLUID_SHELL_EXPLOSION.playAt(level, x, y, z, 3.0f, 0.9f + level.f_46441_.m_188501_() * 0.1f, false);
        level.m_6493_((ParticleOptions)new FluidCloudParticleData(), true, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void lavaFluidShellExplode(FluidBlobEffectRegistry.OnFluidShellExplode.Context context) {
        Level level = context.level();
        double x = context.x();
        double y = context.y();
        double z = context.z();
        CBCSoundEvents.LAVA_FLUID_RELEASE.playAt(level, x, y, z, 2.25f, 1.0f + level.f_46441_.m_188501_() * 0.1f, false);
        CBCSoundEvents.FLUID_SHELL_EXPLOSION.playAt(level, x, y, z, 3.0f, 0.9f + level.f_46441_.m_188501_() * 0.1f, false);
        level.m_6493_((ParticleOptions)new FluidCloudParticleData(), true, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void potionFluidShellExplode(FluidBlobEffectRegistry.OnFluidShellExplode.Context context) {
        Level level = context.level();
        double x = context.x();
        double y = context.y();
        double z = context.z();
        CBCSoundEvents.POTION_FLUID_RELEASE.playAt(level, x, y, z, 3.0f, 0.9f + level.f_46441_.m_188501_() * 0.1f, false);
        CBCSoundEvents.FLUID_SHELL_EXPLOSION.playAt(level, x, y, z, 3.0f, 0.9f + level.f_46441_.m_188501_() * 0.1f, false);
        level.m_6493_((ParticleOptions)new FluidCloudParticleData(), true, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void douseFire(BlockPos root, FluidBlobBurst blob, Level level) {
        float chance = FluidBlobBurst.getBlockAffectChance();
        if (chance == 0.0f) {
            return;
        }
        AABB bounds = blob.getAreaOfEffect(root);
        BlockPos pos1 = new BlockPos(Math.floor(bounds.f_82288_), Math.floor(bounds.f_82289_), Math.floor(bounds.f_82290_));
        BlockPos pos2 = new BlockPos(Math.floor(bounds.f_82291_), Math.floor(bounds.f_82292_), Math.floor(bounds.f_82293_));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            if (level.m_213780_().m_188501_() > chance) continue;
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(BlockTags.f_13076_)) {
                level.m_7471_(pos, false);
                continue;
            }
            if (AbstractCandleBlock.m_151933_((BlockState)state)) {
                AbstractCandleBlock.m_151899_(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                continue;
            }
            if (CampfireBlock.m_51319_((BlockState)state)) {
                level.m_5898_(null, 1009, pos, 0);
                CampfireBlock.m_152749_((Entity)blob.m_37282_(), (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
                continue;
            }
            if (!CandleCakeBlock.m_151933_((BlockState)state)) continue;
            AbstractCandleBlock.m_151899_(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
        }
    }

    public static void spawnFire(BlockPos root, FluidBlobBurst blob, Level level) {
        float chance = FluidBlobBurst.getBlockAffectChance();
        if (chance == 0.0f) {
            return;
        }
        AABB bounds = blob.getAreaOfEffect(root);
        BlockPos pos1 = new BlockPos(Math.floor(bounds.f_82288_), Math.floor(bounds.f_82289_), Math.floor(bounds.f_82290_));
        BlockPos pos2 = new BlockPos(Math.floor(bounds.f_82291_), Math.floor(bounds.f_82292_), Math.floor(bounds.f_82293_));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            if (level.m_213780_().m_188501_() > chance) continue;
            BlockState state = level.m_8055_(pos);
            if (level.m_46859_(pos)) {
                level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
                continue;
            }
            if (!CandleBlock.m_152845_((BlockState)state) && !CampfireBlock.m_51321_((BlockState)state) && !CandleCakeBlock.m_152910_((BlockState)state)) continue;
            level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            level.m_142346_(null, GameEvent.f_157797_, pos);
        }
    }

    public static void spawnGasCloud(BlockPos pos, FluidBlobBurst blob, Level level) {
        CompoundTag tag = blob.getFluidStack().data();
        GasCloudEntity gasCloud = (GasCloudEntity)CBCEntityTypes.GAS_CLOUD.create(level);
        gasCloud.m_146884_(Vec3.m_82512_((Vec3i)pos));
        gasCloud.setWaitTime(10);
        gasCloud.setSize(blob.getBlobSize());
        gasCloud.setDuration(300);
        gasCloud.setPotion(PotionUtils.m_43577_((CompoundTag)tag));
        for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)tag)) {
            gasCloud.addEffect(new MobEffectInstance(effect));
        }
        gasCloud.setFixedColor(PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag)) | 0xFF000000);
        level.m_7967_((Entity)gasCloud);
    }
}

