/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.network;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.utility.Components;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.SyncsExtraDataOnAdd;
import rbasamoyai.createbigcannons.block_hit_effects.BackupBlockHitEffects;
import rbasamoyai.createbigcannons.block_hit_effects.BlockHitEffect;
import rbasamoyai.createbigcannons.block_hit_effects.BlockHitEffectsHandler;
import rbasamoyai.createbigcannons.block_hit_effects.ProjectileHitEffect;
import rbasamoyai.createbigcannons.block_hit_effects.ProjectileHitEffectsHandler;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.sounds.AirAbsorptionWrapper;
import rbasamoyai.createbigcannons.mixin.client.ClientLevelAccessor;
import rbasamoyai.createbigcannons.munitions.ImpactExplosion;
import rbasamoyai.createbigcannons.munitions.ShellExplosion;
import rbasamoyai.createbigcannons.munitions.autocannon.flak.FlakExplosion;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobBurst;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidExplosion;
import rbasamoyai.createbigcannons.munitions.big_cannon.mortar_stone.MortarStoneExplosion;
import rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel.ShrapnelExplosion;
import rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell.SmokeExplosion;
import rbasamoyai.createbigcannons.network.ClientboundAnimateCannonContraptionPacket;
import rbasamoyai.createbigcannons.network.ClientboundBlastSoundPacket;
import rbasamoyai.createbigcannons.network.ClientboundCBCExplodePacket;
import rbasamoyai.createbigcannons.network.ClientboundCheckChannelVersionPacket;
import rbasamoyai.createbigcannons.network.ClientboundFluidBlobStackSyncPacket;
import rbasamoyai.createbigcannons.network.ClientboundFluidExplodePacket;
import rbasamoyai.createbigcannons.network.ClientboundNotifyTagReloadPacket;
import rbasamoyai.createbigcannons.network.ClientboundPlayBlockHitEffectPacket;
import rbasamoyai.createbigcannons.network.ClientboundPreciseRotationSyncPacket;
import rbasamoyai.createbigcannons.network.ClientboundSendCustomBreakProgressPacket;
import rbasamoyai.createbigcannons.network.ClientboundSyncExtraEntityDataPacket;
import rbasamoyai.createbigcannons.network.ClientboundUpdateContraptionPacket;
import rbasamoyai.createbigcannons.remix.CustomBlockDamageDisplay;
import rbasamoyai.createbigcannons.remix.CustomExplosion;

public class CBCClientHandlers {
    public static void updateContraption(ClientboundUpdateContraptionPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.f_91073_.m_6815_(pkt.id());
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity ace = (AbstractContraptionEntity)entity;
        Contraption contraption = ace.getContraption();
        if (contraption != null) {
            contraption.getBlocks().putAll(pkt.changes());
            for (Map.Entry<BlockPos, StructureTemplate.StructureBlockInfo> entry : pkt.changes().entrySet()) {
                BlockEntity be = (BlockEntity)contraption.presentBlockEntities.get(entry.getKey());
                StructureTemplate.StructureBlockInfo info = entry.getValue();
                if (be == null || info.f_74677_ == null) continue;
                CompoundTag copy = info.f_74677_.m_6426_();
                copy.m_128405_("x", info.f_74675_.m_123341_());
                copy.m_128405_("y", info.f_74675_.m_123342_());
                copy.m_128405_("z", info.f_74675_.m_123343_());
                be.m_142466_(copy);
            }
            contraption.deferInvalidate = true;
        }
    }

    public static void animateCannon(ClientboundAnimateCannonContraptionPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.f_91073_.m_6815_(pkt.id());
        if (entity instanceof PitchOrientedContraptionEntity) {
            PitchOrientedContraptionEntity poce = (PitchOrientedContraptionEntity)entity;
            poce.handleAnimation();
        }
    }

    public static void checkVersion(ClientboundCheckChannelVersionPacket pkt) {
        if ("12.2.0".equals(pkt.serverVersion())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null) {
            mc.m_91403_().m_7026_((Component)Components.literal((String)"Create Big Cannons on the client uses a different network format than the server.").m_130946_(" Please use a matching format."));
        }
    }

    public static void syncPreciseRotation(ClientboundPreciseRotationSyncPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91073_.m_6815_(pkt.entityId());
        if (entity == null) {
            return;
        }
        entity.m_6453_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), pkt.yRot(), pkt.xRot(), 3, false);
    }

    public static void updateFluidBlob(ClientboundFluidBlobStackSyncPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91073_.m_6815_(pkt.entityId());
        if (entity instanceof FluidBlobBurst) {
            FluidBlobBurst blobBurst = (FluidBlobBurst)entity;
            blobBurst.setFluidStack(pkt.fstack());
        } else {
            CreateBigCannons.LOGGER.error("Invalid ClientboundFluidBlobStackSyncPacket for non-fluid blob burst entity: " + entity);
        }
    }

    public static void addExplosionFromServer(ClientboundCBCExplodePacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        CustomExplosion.Impl explosion = switch (pkt.explosionType()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientboundCBCExplodePacket.ExplosionType.SHRAPNEL -> new ShrapnelExplosion((Level)mc.f_91073_, pkt);
            case ClientboundCBCExplodePacket.ExplosionType.FLAK -> new FlakExplosion((Level)mc.f_91073_, pkt);
            case ClientboundCBCExplodePacket.ExplosionType.SMOKE -> new SmokeExplosion((Level)mc.f_91073_, pkt);
            case ClientboundCBCExplodePacket.ExplosionType.MORTAR_STONE -> new MortarStoneExplosion((Level)mc.f_91073_, pkt);
            case ClientboundCBCExplodePacket.ExplosionType.IMPACT -> new ImpactExplosion((Level)mc.f_91073_, pkt);
            case ClientboundCBCExplodePacket.ExplosionType.SHELL, ClientboundCBCExplodePacket.ExplosionType.SHELL_NO_EFFECTS -> new ShellExplosion((Level)mc.f_91073_, pkt);
        };
        explosion.m_46075_(true);
        mc.f_91074_.m_20256_(mc.f_91074_.m_20184_().m_82520_((double)pkt.knockbackX(), (double)pkt.knockbackY(), (double)pkt.knockbackZ()));
    }

    public static void addFluidExplosionFromServer(ClientboundFluidExplodePacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        FluidExplosion explosion = new FluidExplosion((Level)mc.f_91073_, pkt);
        explosion.m_46075_(true);
        mc.f_91074_.m_20256_(mc.f_91074_.m_20184_().m_82520_((double)pkt.knockbackX(), (double)pkt.knockbackY(), (double)pkt.knockbackZ()));
    }

    public static void reloadTagDependentClientResources(ClientboundNotifyTagReloadPacket pkt) {
        BlockHitEffectsHandler.loadTags();
    }

    public static void playBlockHitEffect(ClientboundPlayBlockHitEffectPacket pkt) {
        BlockState blockState = pkt.blockState();
        boolean isLiquid = blockState.m_60734_() instanceof LiquidBlock;
        if (isLiquid && !((Boolean)CBCConfigs.CLIENT.showProjectileSplashes.get()).booleanValue() || !isLiquid && !((Boolean)CBCConfigs.CLIENT.showProjectileImpacts.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            return;
        }
        BlockHitEffect blockEffect = isLiquid ? BlockHitEffectsHandler.getFluidProperties(blockState) : BlockHitEffectsHandler.getBlockProperties(blockState);
        ProjectileHitEffect projectileEffect = ProjectileHitEffectsHandler.getProperties(pkt.entityType());
        Vec3 vel = new Vec3((double)pkt.dx(), (double)pkt.dy(), (double)pkt.dz());
        double magnitude = projectileEffect.getMagnitude(vel);
        vel = vel.m_82541_().m_82490_(magnitude);
        if (blockEffect == null) {
            if (isLiquid) {
                BackupBlockHitEffects.backupFluidEffect((Level)minecraft.f_91073_, pkt.blockState(), pkt.deflect(), pkt.forceDisplay(), pkt.x(), pkt.y(), pkt.z(), vel.f_82479_, vel.f_82480_, vel.f_82481_, projectileEffect);
            } else {
                BackupBlockHitEffects.backupSolidEffect((Level)minecraft.f_91073_, pkt.blockState(), pkt.deflect(), pkt.forceDisplay(), pkt.x(), pkt.y(), pkt.z(), vel.f_82479_, vel.f_82480_, vel.f_82481_, projectileEffect);
            }
        } else {
            blockEffect.playEffect((Level)minecraft.f_91073_, pkt.deflect(), pkt.forceDisplay(), pkt.x(), pkt.y(), pkt.z(), vel.f_82479_, vel.f_82480_, vel.f_82481_, pkt.entityType(), pkt.blockState(), projectileEffect);
        }
    }

    public static void syncExtraEntityData(ClientboundSyncExtraEntityDataPacket pkt) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || !((entity = mc.f_91073_.m_6815_(pkt.entityId())) instanceof SyncsExtraDataOnAdd)) {
            return;
        }
        SyncsExtraDataOnAdd round = (SyncsExtraDataOnAdd)entity;
        round.readExtraSyncData(pkt.data());
    }

    public static void setCustomBlockDamage(ClientboundSendCustomBreakProgressPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        ClientLevelAccessor clAccessor = (ClientLevelAccessor)mc.f_91073_;
        ((CustomBlockDamageDisplay)clAccessor.getLevelRenderer()).createbigcannons$trackCustomProgress(pkt.pos(), pkt.damage());
    }

    public static void playBlastSound(ClientboundBlastSoundPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Object sound = new SimpleSoundInstance(pkt.sound(), pkt.source(), pkt.volume(), pkt.pitch(), RandomSource.m_216335_((long)mc.f_91073_.f_46441_.m_188505_()), pkt.x(), pkt.y(), pkt.z());
        if (((Boolean)CBCConfigs.CLIENT.blastSoundAirAbsorption.get()).booleanValue()) {
            sound = new AirAbsorptionWrapper((SoundInstance)sound, pkt.airAbsorption());
        }
        if (!CBCConfigs.CLIENT.isInstantaneousBlastEffect() && mc.f_91074_ != null) {
            double distSqr = mc.f_91074_.m_20275_(pkt.x(), pkt.y(), pkt.z());
            double timeInSec = Math.sqrt(distSqr) / (double)CBCConfigs.CLIENT.blastEffectDelaySpeed.getF();
            mc.m_91106_().m_120369_((SoundInstance)sound, Mth.m_14107_((double)(timeInSec * 20.0)));
        } else {
            mc.m_91106_().m_120367_((SoundInstance)sound);
        }
    }
}

