/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.init;

import java.util.Arrays;
import java.util.EnumMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xyz.vsngamer.elevatorid.ElevatorModTab;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;

public class Registry {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"elevatorid");
    public static final EnumMap<DyeColor, RegistryObject<ElevatorBlock>> ELEVATOR_BLOCKS = new EnumMap(DyeColor.class);
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    public static final RegistryObject<BlockEntityType<ElevatorTileEntity>> ELEVATOR_TILE_ENTITY;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    public static final RegistryObject<MenuType<ElevatorContainer>> ELEVATOR_CONTAINER;
    private static final DeferredRegister<SoundEvent> SOUNDS;
    public static final RegistryObject<SoundEvent> TELEPORT_SOUND;
    public static final RegistryObject<SoundEvent> CAMOUFLAGE_SOUND;

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        SOUNDS.register(modEventBus);
    }

    static {
        Arrays.stream(DyeColor.values()).forEach(color -> ELEVATOR_BLOCKS.put((DyeColor)color, (RegistryObject<ElevatorBlock>)BLOCKS.register("elevator_" + color.m_41065_(), () -> new ElevatorBlock((DyeColor)color))));
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"elevatorid");
        ELEVATOR_TILE_ENTITY = BLOCK_ENTITIES.register("elevator_tile", () -> BlockEntityType.Builder.m_155273_(ElevatorTileEntity::new, (Block[])((Block[])ELEVATOR_BLOCKS.values().stream().map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"elevatorid");
        ELEVATOR_BLOCKS.forEach((color, o) -> ITEMS.register("elevator_" + color.m_41065_(), () -> new BlockItem((Block)o.get(), new Item.Properties().m_41491_(ElevatorModTab.TAB))));
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"elevatorid");
        ELEVATOR_CONTAINER = CONTAINERS.register("elevator_container", () -> IForgeMenuType.create((windowId, inv, data) -> new ElevatorContainer(windowId, data.m_130135_(), inv.f_35978_)));
        SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"elevatorid");
        TELEPORT_SOUND = SOUNDS.register("teleport", () -> new SoundEvent(new ResourceLocation("elevatorid", "teleport")));
        CAMOUFLAGE_SOUND = SOUNDS.register("camouflage", () -> new SoundEvent(new ResourceLocation("elevatorid", "camouflage")));
    }
}

