/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.createframed.registry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.decoration.TrainTrapdoorBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.GlassPaneBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.GlassPaneCTBehaviour;
import com.simibubi.create.foundation.block.connected.SimpleCTBehaviour;
import com.simibubi.create.foundation.data.BuilderTransformers;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dakotapride.createframed.CreateFramedMod;
import net.dakotapride.createframed.block.TintedConnectedGlassBlock;
import net.dakotapride.createframed.block.TintedConnectedGlassPaneBlock;
import net.dakotapride.createframed.block.TintedFramedGlassTrapdoorBlock;
import net.dakotapride.createframed.block.TintedGlassPaneBlock;
import net.dakotapride.createframed.block.behaviour.FramedDoorMovingInteraction;
import net.dakotapride.createframed.block.behaviour.FramedGlassTrapdoorCTBehaviour;
import net.dakotapride.createframed.block.behaviour.FramedSlidingDoorMovementBehaviour;
import net.dakotapride.createframed.block.door.FramedGlassSlidingDoorBlock;
import net.dakotapride.createframed.block.door.TintedFramedGlassSlidingDoorBlock;
import net.dakotapride.createframed.registry.CreateFramedTabs;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class CreateFramedBuilderTransformers {
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateFramedMod.REGISTRATE.creativeModeTab(() -> CreateFramedTabs.CREATE_FRAMED);

    public static BlockEntry<ConnectedGlassBlock> colouredFramedGlass(String name, Supplier<ConnectedTextureBehaviour> behaviour, Block stainedBlock) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name, ConnectedGlassBlock::new).onRegister(CreateRegistrate.connectedTextures(behaviour))).addLayer(() -> RenderType::m_110466_).initialProperties(() -> stainedBlock).properties(p -> p.m_60922_(CreateFramedBuilderTransformers::never).m_60924_(CreateFramedBuilderTransformers::never).m_60960_(CreateFramedBuilderTransformers::never).m_60971_(CreateFramedBuilderTransformers::never).m_60955_()).item().build()).register();
    }

    public static BlockEntry<GlassBlock> colouredTiledGlass(String colourType) {
        return ((BlockBuilder)REGISTRATE.block(colourType + "_stained_tiled_glass", GlassBlock::new).initialProperties(() -> Blocks.f_50058_).addLayer(() -> RenderType::m_110466_).item().build()).register();
    }

    public static BlockEntry<GlassPaneBlock> colouredTiledGlassPane(String colourType) {
        return ((BlockBuilder)REGISTRATE.block(colourType + "_stained_tiled_glass_pane", GlassPaneBlock::new).initialProperties(() -> Blocks.f_50185_).addLayer(() -> RenderType::m_110466_).item().build()).register();
    }

    public static BlockEntry<TintedGlassBlock> tintedTiledGlass() {
        return ((BlockBuilder)REGISTRATE.block("tinted_tiled_glass", TintedGlassBlock::new).initialProperties(() -> Blocks.f_152498_).addLayer(() -> RenderType::m_110466_).item().build()).register();
    }

    public static BlockEntry<TintedGlassPaneBlock> tintedTiledGlassPane() {
        return ((BlockBuilder)REGISTRATE.block("tinted_tiled_glass_pane", TintedGlassPaneBlock::new).initialProperties(() -> Blocks.f_50185_).addLayer(() -> RenderType::m_110466_).item().build()).register();
    }

    public static <B extends FramedGlassSlidingDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> slidingDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(Material.f_76320_).properties(p -> p.m_60913_(3.0f, 6.0f)).addLayer(() -> RenderType::m_110466_).onRegister(AllInteractionBehaviours.interactionBehaviour((MovingInteractionBehaviour)new FramedDoorMovingInteraction()))).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)new FramedSlidingDoorMovementBehaviour()))).item().build();
    }

    public static <B extends TintedFramedGlassSlidingDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> tintedSlidingDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(Material.f_76320_).properties(p -> p.m_60913_(3.0f, 6.0f)).addLayer(() -> RenderType::m_110466_).onRegister(AllInteractionBehaviours.interactionBehaviour((MovingInteractionBehaviour)new FramedDoorMovingInteraction()))).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)new FramedSlidingDoorMovementBehaviour()))).item().build();
    }

    public static BlockEntry<FramedGlassSlidingDoorBlock> framedGlassSlidingDoor(String type, MaterialColor colour) {
        return ((BlockBuilder)REGISTRATE.block(type + "_door", FramedGlassSlidingDoorBlock::new).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.m_60918_(SoundType.f_56744_).m_155949_(colour)).transform(CreateFramedBuilderTransformers.slidingDoor(type))).properties(BlockBehaviour.Properties::m_60955_).register();
    }

    public static BlockEntry<TintedFramedGlassSlidingDoorBlock> tintedFramedGlassSlidingDoor(String type, MaterialColor colour) {
        return ((BlockBuilder)REGISTRATE.block(type + "_door", TintedFramedGlassSlidingDoorBlock::new).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.m_60918_(SoundType.f_56744_).m_155949_(colour)).transform(CreateFramedBuilderTransformers.tintedSlidingDoor(type))).properties(BlockBehaviour.Properties::m_60955_).register();
    }

    public static BlockEntry<TrainTrapdoorBlock> framedGlassTrapdoor(String name, MaterialColor colour, CTSpriteShiftEntry spriteShiftEntry) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name + "_trapdoor", TrainTrapdoorBlock::new).initialProperties(SharedProperties::softMetal).transform((NonNullFunction)BuilderTransformers.trapdoor((boolean)false))).properties(p -> p.m_60918_(SoundType.f_56744_).m_60955_().m_155949_(colour)).onRegister(CreateRegistrate.connectedTextures(() -> new FramedGlassTrapdoorCTBehaviour(spriteShiftEntry)))).addLayer(() -> RenderType::m_110466_).register();
    }

    public static BlockEntry<TintedFramedGlassTrapdoorBlock> tintedFramedGlassTrapdoor(String name, MaterialColor colour, CTSpriteShiftEntry spriteShiftEntry) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name + "_trapdoor", TintedFramedGlassTrapdoorBlock::new).initialProperties(SharedProperties::softMetal).transform((NonNullFunction)BuilderTransformers.trapdoor((boolean)false))).properties(p -> p.m_60918_(SoundType.f_56744_).m_60955_().m_155949_(colour)).onRegister(CreateRegistrate.connectedTextures(() -> new FramedGlassTrapdoorCTBehaviour(spriteShiftEntry)))).addLayer(() -> RenderType::m_110466_).register();
    }

    public static BlockEntry<ConnectedGlassPaneBlock> colouredFramedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift) {
        ResourceLocation sideTexture = CreateFramedMod.asResource(name);
        ResourceLocation itemSideTexture = CreateFramedMod.asResource(name);
        ResourceLocation topTexture = CreateFramedMod.asResource(name + "_top");
        Supplier<Supplier<RenderType>> renderType = () -> RenderType::m_110466_;
        return CreateFramedBuilderTransformers.connectedGlassPane(name, parent, ctshift, sideTexture, itemSideTexture, topTexture, renderType);
    }

    public static BlockEntry<TintedConnectedGlassPaneBlock> tintedFramedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift) {
        ResourceLocation sideTexture = CreateFramedMod.asResource(name);
        ResourceLocation itemSideTexture = CreateFramedMod.asResource(name);
        ResourceLocation topTexture = CreateFramedMod.asResource(name + "_top");
        Supplier<Supplier<RenderType>> renderType = () -> RenderType::m_110466_;
        return CreateFramedBuilderTransformers.tintedConnectedGlassPane(name, parent, ctshift, sideTexture, itemSideTexture, topTexture, renderType);
    }

    public static BlockEntry<TintedConnectedGlassBlock> tintedFramedGlass(CTSpriteShiftEntry entry) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block("tinted_framed_glass", TintedConnectedGlassBlock::new).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(entry)))).addLayer(() -> RenderType::m_110466_).initialProperties(() -> Blocks.f_152498_).properties(p -> p.m_60922_(CreateFramedBuilderTransformers::never).m_60924_(CreateFramedBuilderTransformers::never).m_60960_(CreateFramedBuilderTransformers::never).m_60971_(CreateFramedBuilderTransformers::never).m_60955_()).item().build()).register();
    }

    public static BlockEntry<TintedConnectedGlassBlock> tintedFramedGlass(String name, ConnectedTextureBehaviour.Base behaviour) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name + "_tinted_framed_glass", TintedConnectedGlassBlock::new).onRegister(CreateRegistrate.connectedTextures(() -> behaviour))).addLayer(() -> RenderType::m_110466_).initialProperties(() -> Blocks.f_152498_).properties(p -> p.m_60922_(CreateFramedBuilderTransformers::never).m_60924_(CreateFramedBuilderTransformers::never).m_60960_(CreateFramedBuilderTransformers::never).m_60971_(CreateFramedBuilderTransformers::never).m_60955_()).item().build()).register();
    }

    private static boolean never(BlockState p_235436_0_, BlockGetter p_235436_1_, BlockPos p_235436_2_) {
        return false;
    }

    private static Boolean never(BlockState p_235427_0_, BlockGetter p_235427_1_, BlockPos p_235427_2_, EntityType<?> p_235427_3_) {
        return false;
    }

    private static BlockEntry<ConnectedGlassPaneBlock> connectedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift, ResourceLocation sideTexture, ResourceLocation itemSideTexture, ResourceLocation topTexture, Supplier<Supplier<RenderType>> renderType) {
        NonNullConsumer connectedTextures = CreateRegistrate.connectedTextures(() -> new GlassPaneCTBehaviour((CTSpriteShiftEntry)ctshift.get()));
        String CGPparents = "block/connected_glass_pane/";
        String prefix = name + "_pane_";
        Function<RegistrateBlockstateProvider, ModelFile> post = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "post", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> side = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "side", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> sideAlt = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "side_alt", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSide = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "noside", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSideAlt = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "noside_alt", sideTexture, topTexture);
        NonNullBiConsumer stateProvider = (c, p) -> p.paneBlock((IronBarsBlock)c.get(), (ModelFile)post.apply((RegistrateBlockstateProvider)p), (ModelFile)side.apply((RegistrateBlockstateProvider)p), (ModelFile)sideAlt.apply((RegistrateBlockstateProvider)p), (ModelFile)noSide.apply((RegistrateBlockstateProvider)p), (ModelFile)noSideAlt.apply((RegistrateBlockstateProvider)p));
        return CreateFramedBuilderTransformers.glassPane(name, parent, itemSideTexture, topTexture, ConnectedGlassPaneBlock::new, renderType, connectedTextures, stateProvider);
    }

    private static BlockEntry<TintedConnectedGlassPaneBlock> tintedConnectedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift, ResourceLocation sideTexture, ResourceLocation itemSideTexture, ResourceLocation topTexture, Supplier<Supplier<RenderType>> renderType) {
        NonNullConsumer connectedTextures = CreateRegistrate.connectedTextures(() -> new GlassPaneCTBehaviour((CTSpriteShiftEntry)ctshift.get()));
        String CGPparents = "block/connected_glass_pane/";
        String prefix = name + "_pane_";
        Function<RegistrateBlockstateProvider, ModelFile> post = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "post", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> side = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "side", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> sideAlt = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "side_alt", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSide = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "noside", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSideAlt = CreateFramedBuilderTransformers.getPaneModelProvider(CGPparents, prefix, "noside_alt", sideTexture, topTexture);
        NonNullBiConsumer stateProvider = (c, p) -> p.paneBlock((IronBarsBlock)c.get(), (ModelFile)post.apply((RegistrateBlockstateProvider)p), (ModelFile)side.apply((RegistrateBlockstateProvider)p), (ModelFile)sideAlt.apply((RegistrateBlockstateProvider)p), (ModelFile)noSide.apply((RegistrateBlockstateProvider)p), (ModelFile)noSideAlt.apply((RegistrateBlockstateProvider)p));
        return CreateFramedBuilderTransformers.glassPane(name, parent, itemSideTexture, topTexture, TintedConnectedGlassPaneBlock::new, renderType, connectedTextures, stateProvider);
    }

    private static Function<RegistrateBlockstateProvider, ModelFile> getPaneModelProvider(String CGPparents, String prefix, String partial, ResourceLocation sideTexture, ResourceLocation topTexture) {
        return p -> ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(prefix + partial, CreateFramedMod.asResource(CGPparents + partial))).texture("pane", sideTexture)).texture("edge", topTexture);
    }

    private static <G extends GlassPaneBlock> BlockEntry<G> glassPane(String name, Supplier<? extends Block> parent, ResourceLocation sideTexture, ResourceLocation topTexture, NonNullFunction<BlockBehaviour.Properties, G> factory, Supplier<Supplier<RenderType>> renderType, NonNullConsumer<? super G> connectedTextures, NonNullBiConsumer<DataGenContext<Block, G>, RegistrateBlockstateProvider> stateProvider) {
        name = (String)name + "_pane";
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block((String)name, factory).onRegister(connectedTextures)).addLayer(renderType).initialProperties(() -> Blocks.f_50185_).properties(p -> p.m_155949_(((Block)parent.get()).m_60590_())).blockstate(stateProvider).item().build()).register();
    }
}

