/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AdjustVolumeSlider
extends DebouncedSlider {
    protected static final Component MUTED = Component.m_237115_((String)"message.voicechat.muted");
    protected static final double YELLOW_DB = -20.0;
    protected static final double RED_DB = -6.0;
    protected static final float MAXIMUM = 4.0f;
    protected final AdjustVolumeEntry volumeConfigEntry;

    public AdjustVolumeSlider(int xIn, int yIn, int widthIn, int heightIn, AdjustVolumeEntry volumeConfigEntry) {
        super(xIn, yIn, widthIn, heightIn, (Component)Component.m_237119_(), volumeConfigEntry.get() / 4.0);
        this.volumeConfigEntry = volumeConfigEntry;
        this.m_5695_();
    }

    protected void m_5695_() {
        if (this.f_93577_ <= 0.0) {
            this.m_93666_(MUTED);
            return;
        }
        long amp = Math.round(this.f_93577_ * 4.0 * 100.0 - 100.0);
        this.m_93666_((Component)Component.m_237110_((String)"message.voicechat.volume_amplification", (Object[])new Object[]{((float)amp > 0.0f ? "+" : "") + amp + "%"}));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float f) {
        super.m_6305_(poseStack, mouseX, mouseY, f);
        double audioLevel = this.volumeConfigEntry.getAudioLevel();
        if (audioLevel <= -127.0) {
            return;
        }
        double adjustedLevel = AudioUtils.linearToDb(this.getMultiplier());
        int barWidth = (int)((double)this.m_5711_() * AudioUtils.dbToPerc(audioLevel + adjustedLevel));
        double yellowPerc = AudioUtils.dbToPerc(-20.0);
        double redPerc = AudioUtils.dbToPerc(-6.0);
        int greenWidth = (int)((double)this.m_5711_() * yellowPerc);
        int yellowWidth = (int)((double)this.m_5711_() * redPerc) - greenWidth;
        int width = this.m_5711_();
        Screen.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + Math.min(greenWidth, barWidth)), (int)(this.f_93621_ + 1), (int)-16711936);
        if (barWidth > greenWidth) {
            Screen.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ + greenWidth), (int)this.f_93621_, (int)(this.f_93620_ + Math.min(greenWidth + yellowWidth, barWidth)), (int)(this.f_93621_ + 1), (int)-256);
            if (barWidth > greenWidth + yellowWidth) {
                Screen.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ + greenWidth + yellowWidth), (int)this.f_93621_, (int)(this.f_93620_ + Math.min(width, barWidth)), (int)(this.f_93621_ + 1), (int)-65536);
            }
        }
    }

    @Override
    public void applyDebounced() {
        this.volumeConfigEntry.save(this.getMultiplier());
    }

    private double getMultiplier() {
        return this.f_93577_ * 4.0;
    }

    public static interface AdjustVolumeEntry {
        public void save(double var1);

        public double get();

        public double getAudioLevel();
    }
}

