/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.base;

import ic2.api.energy.EnergyNet;
import ic2.api.util.DirectionList;
import ic2.core.utils.helpers.Formatters;
import ic2.jadeplugin.base.elements.CommonBarElement;
import ic2.jadeplugin.base.elements.CommonBoxElement;
import ic2.jadeplugin.base.elements.CommonFluidBarElement;
import ic2.jadeplugin.base.elements.CommonItemStackElement;
import ic2.jadeplugin.base.elements.CommonPaddingElement;
import ic2.jadeplugin.base.elements.CommonTextElement;
import ic2.jadeplugin.base.interfaces.IJadeElementBuilder;
import ic2.jadeplugin.base.interfaces.IJadeHelper;
import ic2.jadeplugin.helpers.EnergyContainer;
import ic2.jadeplugin.helpers.TextFormatter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class JadeHelper
implements IJadeHelper {
    public static final List<BlockEntity> TANK_REMOVAL = new ObjectArrayList();
    private final ListTag DATA = new ListTag();
    public static final String ADD_TAG = "add";
    public static final String APPEND_TAG = "append";

    @Override
    public void add(IJadeElementBuilder element) {
        CompoundTag addTag = new CompoundTag();
        CompoundTag elementTag = element.save(new CompoundTag());
        elementTag.m_128379_(ADD_TAG, true);
        addTag.m_128365_(element.getTagId(), (Tag)elementTag);
        this.DATA.add((Object)addTag);
    }

    @Override
    public void append(IJadeElementBuilder element) {
        CompoundTag elementTag = element.save(new CompoundTag());
        CompoundTag appendTag = new CompoundTag();
        elementTag.m_128379_(APPEND_TAG, true);
        appendTag.m_128365_(element.getTagId(), (Tag)elementTag);
        this.DATA.add((Object)appendTag);
    }

    @Override
    public void transferData(CompoundTag serverData) {
        if (!this.DATA.isEmpty()) {
            serverData.m_128365_("Data", (Tag)this.DATA);
        }
    }

    public void addTankInfo(BlockEntity blockEntity) {
        TANK_REMOVAL.add(blockEntity);
        if (blockEntity instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)blockEntity;
            this.loadTankData(fluidHandler);
        } else {
            blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(this::loadTankData);
        }
    }

    public void loadTankData(IFluidHandler fluidHandler) {
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            FluidStack fluid = fluidHandler.getFluidInTank(i);
            if (fluid.getAmount() <= 0) continue;
            this.add(new CommonFluidBarElement(fluid, fluidHandler.getTankCapacity(i), false));
        }
    }

    public void addAveragesFull(EnergyContainer container) {
        this.addAveragesIn(container, 3);
        this.addAveragesOut(container, 0);
    }

    public void addAveragesIn(EnergyContainer container) {
        this.addAveragesIn(container, 3);
    }

    public void addAveragesIn(EnergyContainer container, int padding) {
        int averageIn = container.getAverageIn();
        int packetsIn = container.getPacketsIn();
        MutableComponent full = this.getFullStatus(averageIn, packetsIn);
        if (averageIn > 0) {
            this.paddingY(padding);
            this.text((Component)TextFormatter.AQUA.translate("info.energy.in", Formatters.EU_FORMAT.format(averageIn)));
            if (packetsIn <= 0) {
                packetsIn = 1;
            }
            this.text((Component)full.m_7220_((Component)TextFormatter.AQUA.translate("info.packet.in", Formatters.EU_FORMAT.format(packetsIn))));
        }
    }

    public void addAveragesOut(EnergyContainer container) {
        this.addAveragesOut(container, 3);
    }

    public void addAveragesOut(EnergyContainer container, int padding) {
        int averageOut = container.getAverageOut();
        int packetsOut = container.getPacketsOut();
        MutableComponent full = this.getFullStatus(averageOut, packetsOut);
        if (averageOut > 0) {
            this.paddingY(padding);
            this.text((Component)TextFormatter.AQUA.translate("info.energy.out", Formatters.EU_FORMAT.format(averageOut)));
            if (packetsOut <= 0) {
                packetsOut = 1;
            }
            this.text((Component)full.m_7220_((Component)TextFormatter.AQUA.translate("info.packet.out", Formatters.EU_FORMAT.format(packetsOut))));
        }
    }

    public void addCableAverages(int energyFlow, int packetFlow) {
        if (energyFlow > 0) {
            MutableComponent full = this.getFullStatus(energyFlow, packetFlow);
            this.paddingY(3);
            this.text((Component)TextFormatter.AQUA.translate("info.energy.flow", Formatters.EU_FORMAT.format(energyFlow)));
            if (packetFlow <= 0) {
                packetFlow = 1;
            }
            this.text((Component)full.m_7220_((Component)TextFormatter.AQUA.translate("info.packet.flow", Formatters.EU_FORMAT.format(packetFlow))));
        }
    }

    public void centered(Component component) {
        CommonTextElement element = new CommonTextElement(component, true);
        this.add(element);
    }

    public void defaultCentered(Component component) {
        CommonTextElement element = new CommonTextElement((Component)component.m_6881_(), true);
        this.add(element);
    }

    public void defaultCenteredText(String translatable, Object ... args) {
        this.defaultCentered((Component)Component.m_237110_((String)translatable, (Object[])args));
    }

    public void text(Component text) {
        CommonTextElement element = new CommonTextElement(text, false);
        this.add(element);
    }

    public void appendText(Component text) {
        CommonTextElement element = new CommonTextElement(text, false);
        this.append(element);
    }

    public void defaultText(String translatable, Object ... args) {
        this.text((Component)TextFormatter.WHITE.translate(translatable, args));
    }

    public void appendDefaultText(String translatable, Object ... args) {
        this.appendText((Component)Component.m_237110_((String)translatable, (Object[])args));
    }

    public void defaultText(Component component) {
        this.text(component);
    }

    public void appendDefaultText(Component component) {
        this.appendText(component);
    }

    public void bar(int current, int max, Component text, int color) {
        CommonBarElement element = new CommonBarElement(current, max, text, color);
        this.add(element);
    }

    public void fluid(FluidStack fluid, int capacity, boolean ignoreCapacity) {
        CommonFluidBarElement element = new CommonFluidBarElement(fluid, capacity, ignoreCapacity);
        this.add(element);
    }

    public void fluid(FluidStack fluid, int capacity) {
        this.fluid(fluid, capacity, false);
    }

    public void padding(int x, int y) {
        this.add(new CommonPaddingElement(x, y));
    }

    public void paddingX(int x) {
        this.add(new CommonPaddingElement(x, 0));
    }

    public void paddingY(int y) {
        this.add(new CommonPaddingElement(0, y));
    }

    public void appendPadding(int x, int y) {
        this.append(new CommonPaddingElement(x, y));
    }

    public void appendPaddingX(int x) {
        this.append(new CommonPaddingElement(x, 0));
    }

    public void appendPaddingY(int y) {
        this.append(new CommonPaddingElement(0, y));
    }

    public void item(ItemStack stack) {
        CommonItemStackElement stackElement = new CommonItemStackElement(stack, new Vec2(0.0f, -5.0f), "LEFT");
        this.add(stackElement);
    }

    public void appendItem(ItemStack stack) {
        CommonItemStackElement stackElement = new CommonItemStackElement(stack, new Vec2(0.0f, -5.0f), "LEFT");
        this.append(stackElement);
    }

    public void defaultItem(ItemStack stack) {
        CommonItemStackElement stackElement = new CommonItemStackElement(stack, new Vec2(0.0f, 0.0f), "LEFT");
        this.add(stackElement);
    }

    public void appendDefaultItem(ItemStack stack) {
        CommonItemStackElement stackElement = new CommonItemStackElement(stack, new Vec2(0.0f, 0.0f), "LEFT");
        this.append(stackElement);
    }

    public void item(ItemStack stack, Vec2 translation) {
        CommonItemStackElement stackElement = new CommonItemStackElement(stack, translation, "LEFT");
        this.add(stackElement);
    }

    public void appendItem(ItemStack stack, Vec2 translation) {
        CommonItemStackElement stackElement = new CommonItemStackElement(stack, translation, "LEFT");
        this.append(stackElement);
    }

    public void grid(List<ItemStack> stacks, Component component, int size) {
        CommonBoxElement boxElement = new CommonBoxElement(stacks, size);
        this.text(component);
        this.paddingY(2);
        this.add(boxElement);
        this.paddingY(2);
    }

    public void grid(List<ItemStack> stacks, Component component) {
        this.grid(stacks, component, 6);
    }

    public MutableComponent getFullStatus(int energy, int packet) {
        return energy > 0 && packet <= 0 ? Component.m_237113_((String)"~").m_130940_(ChatFormatting.GREEN) : Component.m_237119_();
    }

    public void tierFromPower(int power) {
        int tier = EnergyNet.INSTANCE.getTierFromPower(power);
        this.defaultText("ic2.probe.eu.tier.name", TextFormatter.tier(tier).literal(this.getTierDisplayFromTier(tier)));
    }

    public void tier(int tier) {
        this.defaultText("ic2.probe.eu.tier.name", TextFormatter.tier(tier).literal(this.getTierDisplayFromTier(tier)));
    }

    public void maxIn(int maxIn) {
        int tier = EnergyNet.INSTANCE.getTierFromPower(maxIn);
        this.defaultText("info.energy.max_in", TextFormatter.GREEN.literal("" + maxIn), TextFormatter.tier(tier).literal(this.getTierDisplayFromTier(tier)));
    }

    public void maxInFromTier(int tier) {
        this.defaultText("info.energy.max_in", TextFormatter.GREEN.literal("" + EnergyNet.INSTANCE.getPowerFromTier(tier)), TextFormatter.tier(tier).literal(this.getTierDisplayFromTier(tier)));
    }

    public void maxOut(int maxOut) {
        int tier = EnergyNet.INSTANCE.getTierFromPower(maxOut);
        this.defaultText("info.energy.max_out", TextFormatter.GREEN.literal("" + maxOut), TextFormatter.tier(tier).literal(this.getTierDisplayFromTier(tier)));
    }

    public void usage(int usage) {
        this.defaultText("ic2.probe.eu.usage.name", TextFormatter.GREEN.literal("" + usage));
    }

    public void usage(double usage) {
        this.defaultText("ic2.probe.eu.usage.name", TextFormatter.GREEN.literal("" + usage));
    }

    public String getTierDisplayFromTier(int tier) {
        return switch (tier) {
            case 0 -> "ULV";
            case 1 -> "LV";
            case 2 -> "MV";
            case 3 -> "HV";
            case 4 -> "EV";
            case 5 -> "IV";
            case 6 -> "LuV";
            case 7 -> "ZPM";
            case 8 -> "UV";
            case 9 -> "UHV";
            case 10 -> "UEV";
            case 11 -> "UIV";
            case 12 -> "UMV";
            case 13 -> "UXV";
            case 14 -> "MAX";
            default -> String.valueOf(tier);
        };
    }

    public static Component getSides(DirectionList directionList) {
        if (directionList == null) {
            return Component.m_237119_();
        }
        Map<String, CallSite> replacements = Map.of("north", ChatFormatting.YELLOW + "N", "south", ChatFormatting.BLUE + "S", "east", ChatFormatting.GREEN + "E", "west", ChatFormatting.LIGHT_PURPLE + "W", "down", ChatFormatting.AQUA + "D", "up", ChatFormatting.RED + "U");
        String formatted = directionList.toString().replace("[", "").replace("]", "").replace(",", "");
        for (Map.Entry<String, CallSite> entry : replacements.entrySet()) {
            formatted = formatted.replace(entry.getKey(), (CharSequence)((Object)entry.getValue()));
        }
        return Component.m_237113_((String)formatted);
    }

    public static int getColorForFluid(FluidStack fluid) {
        return fluid.getFluid() == Fluids.f_76195_ ? -29925 : IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor() | 0xFF000000;
    }
}

