/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.base;

import com.google.gson.JsonObject;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.JadeTags;
import ic2.jadeplugin.base.JadeCommonHandler;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.elements.CommonBarElement;
import ic2.jadeplugin.base.elements.CommonBoxElement;
import ic2.jadeplugin.base.elements.CommonFluidBarElement;
import ic2.jadeplugin.base.elements.CommonItemStackElement;
import ic2.jadeplugin.base.elements.CommonPaddingElement;
import ic2.jadeplugin.base.elements.CommonTextElement;
import ic2.jadeplugin.elements.CustomBoxElement;
import ic2.jadeplugin.elements.CustomBoxStyle;
import ic2.jadeplugin.elements.CustomProgressStyle;
import ic2.jadeplugin.elements.CustomTextElement;
import ic2.jadeplugin.helpers.Formatter;
import ic2.jadeplugin.helpers.TextFormatter;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.impl.ui.ProgressStyle;

public class JadeTooltipRenderer
implements IBlockComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final JadeTooltipRenderer INSTANCE = new JadeTooltipRenderer();

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        this.appendTooltips(iTooltip, blockAccessor, iPluginConfig);
    }

    private void appendTooltips(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        boolean forceTOPStyle = config.get(JadeTags.TOP_STYLE);
        boolean showIC2Tanks = config.get(JadeTags.TANK_RENDER);
        TextFormatter defaultFormat = forceTOPStyle ? TextFormatter.WHITE : TextFormatter.GRAY;
        CompoundTag serverData = accessor.getServerData();
        IElementHelper helper = tooltip.getElementHelper();
        if (serverData.m_128425_("Data", 9)) {
            ListTag tagList = serverData.m_128437_("Data", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag elementTag;
                CompoundTag serverTag = tagList.m_128728_(i);
                if (serverTag.m_128441_("jade_addon_padding")) {
                    elementTag = serverTag.m_128469_("jade_addon_padding");
                    CommonPaddingElement paddingElement = CommonPaddingElement.load(elementTag);
                    int x = paddingElement.getX();
                    int y = paddingElement.getY();
                    IElement jadeElement = tooltip.getElementHelper().spacer(x, y);
                    this.addElement(tooltip, jadeElement, elementTag);
                }
                if (serverTag.m_128441_("jade_addon_text")) {
                    elementTag = serverTag.m_128469_("jade_addon_text");
                    CommonTextElement textElement = CommonTextElement.load(elementTag);
                    boolean centered = textElement.isCentered();
                    IElement jadeElement = new CustomTextElement(this.format(textElement.getText(), defaultFormat)).centered(centered).translate(textElement.getTranslation()).align(IElement.Align.valueOf((String)textElement.getSide()));
                    this.addElement(tooltip, jadeElement, elementTag);
                }
                if (serverTag.m_128441_("jade_addon_bar")) {
                    elementTag = serverTag.m_128469_("jade_addon_bar");
                    CommonBarElement barElement = CommonBarElement.load(elementTag);
                    int color = barElement.getColor();
                    int current = barElement.getCurrent();
                    int max = barElement.getMax();
                    BoxStyle boxStyle = forceTOPStyle ? new CustomBoxStyle(ColorUtils.doubleDarker((int)color)) : BoxStyle.DEFAULT;
                    IProgressStyle progressStyle = forceTOPStyle ? new CustomProgressStyle().color(color, ColorUtils.darker((int)color)) : new ProgressStyle().color(color, ColorUtils.darker((int)color));
                    Component label = barElement.getText();
                    IElement jadeElement = helper.progress((float)current / (float)max, label, progressStyle, (IBoxStyle)boxStyle, true);
                    this.addElement(tooltip, jadeElement, elementTag);
                }
                if (serverTag.m_128441_("jade_addon_item")) {
                    elementTag = serverTag.m_128469_("jade_addon_item");
                    CommonItemStackElement stackElement = CommonItemStackElement.load(elementTag);
                    ItemStack stack = stackElement.getStack();
                    IElement jadeElement = tooltip.getElementHelper().item(stack).size(new Vec2(16.0f, 16.0f)).translate(stackElement.getTranslation()).align(IElement.Align.valueOf((String)stackElement.getSide()));
                    this.addElement(tooltip, jadeElement, elementTag);
                }
                if (serverTag.m_128441_("jade_addon_fluid") && showIC2Tanks) {
                    elementTag = serverTag.m_128469_("jade_addon_fluid");
                    CommonFluidBarElement fluidElement = CommonFluidBarElement.load(elementTag);
                    FluidStack fluid = fluidElement.getFluid();
                    int fluidAmount = fluid.getAmount();
                    int max = fluidElement.getMax();
                    boolean ignoreCapacity = fluidElement.ignoreCapacity();
                    if (fluidAmount > 0) {
                        if (forceTOPStyle) {
                            MutableComponent fluidComp = ignoreCapacity ? defaultFormat.component(fluid.getDisplayName()) : defaultFormat.translate("ic2.barrel.info.fluid", fluid.getDisplayName(), Formatter.formatNumber(fluidAmount, String.valueOf(fluidAmount).length() - 1), Formatter.formatNumber(max, String.valueOf(max).length() - 1));
                            IProgressStyle progressStyle = helper.progressStyle().overlay(helper.fluid(fluid));
                            tooltip.add(helper.progress((float)fluid.getAmount() / (float)max, (Component)fluidComp, progressStyle, (IBoxStyle)new CustomBoxStyle(ColorUtils.doubleDarker((int)JadeHelper.getColorForFluid(fluid))), true));
                        } else {
                            String current = IDisplayHelper.get().humanReadableNumber((double)fluid.getAmount(), "B", true);
                            String maxS = IDisplayHelper.get().humanReadableNumber((double)max, "B", true);
                            Object text = ignoreCapacity ? fluid.getDisplayName() : (accessor.showDetails() ? Component.m_237110_((String)"jade.fluid2", (Object[])new Object[]{IDisplayHelper.get().stripColor(fluid.getDisplayName()).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)current).m_130940_(ChatFormatting.WHITE), maxS}).m_130940_(ChatFormatting.GRAY) : Component.m_237110_((String)"jade.fluid", (Object[])new Object[]{IDisplayHelper.get().stripColor(fluid.getDisplayName()), current}));
                            IProgressStyle progressStyle = helper.progressStyle().overlay(helper.fluid(fluid));
                            tooltip.add(helper.progress((float)fluidAmount / (float)max, text, progressStyle, (IBoxStyle)BoxStyle.DEFAULT, true));
                        }
                    }
                }
                if (!serverTag.m_128441_("jade_addon_box")) continue;
                elementTag = serverTag.m_128469_("jade_addon_box");
                CommonBoxElement boxElement = CommonBoxElement.load(elementTag);
                List<ItemStack> gridStacks = boxElement.getGridStacks();
                int size = boxElement.getSize();
                CustomBoxElement box = new CustomBoxElement((IBoxStyle)(forceTOPStyle ? new CustomBoxStyle() : BoxStyle.DEFAULT), gridStacks, size);
                tooltip.add((IElement)box);
            }
        }
    }

    public void addElement(ITooltip iTooltip, IElement jadeElement, CompoundTag elementTag) {
        boolean add = elementTag.m_128471_("add");
        boolean append = elementTag.m_128471_("append");
        if (add) {
            iTooltip.add(jadeElement);
        }
        if (append) {
            iTooltip.append(jadeElement);
        }
    }

    public Component format(Component component, TextFormatter defaultFormatting) {
        TextFormatter existing;
        String color;
        TextFormatter formatting = defaultFormatting;
        JsonObject json = Component.Serializer.m_130716_((Component)component).getAsJsonObject();
        if (json.has("color") && !(color = json.get("color").getAsString()).isEmpty() && (existing = TextFormatter.valueOf(color.toUpperCase(Locale.ROOT))) != TextFormatter.WHITE) {
            formatting = existing;
        }
        return formatting.component(component);
    }

    public ResourceLocation getUid() {
        return JadeTags.INFO_RENDERER;
    }

    public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
        JadeHelper helper = new JadeHelper();
        JadeCommonHandler.THIS.addInfo(helper, blockEntity, (Player)serverPlayer);
        helper.transferData(compoundTag);
    }
}

