/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.misc.textured.TexturedBlockBlock;
import ic2.core.block.misc.textured.TexturedSlabBlock;
import ic2.core.block.misc.textured.TexturedStairsBlock;
import ic2.core.block.misc.textured.TexturedWallBlock;
import ic2.jadeplugin.JadeTags;
import ic2.jadeplugin.base.removals.ModNameRender;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec2;
import snownee.jade.Jade;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.ui.TextElement;
import snownee.jade.util.ModIdentification;

public class TexturedBlockInfo
implements IBlockComponentProvider {
    public static final TexturedBlockInfo INSTANCE = new TexturedBlockInfo();

    @Nullable
    public IElement getIcon(BlockAccessor blockAccessor, IPluginConfig config, IElement currentIcon) {
        ItemStack icon = ItemStack.f_41583_;
        Block block = blockAccessor.getBlock();
        if (block instanceof TexturedBlockBlock || block instanceof TexturedSlabBlock || block instanceof TexturedWallBlock || block instanceof TexturedStairsBlock) {
            icon = TexturedBlockInfo.getFakeIcon(block, blockAccessor);
        }
        return IElementHelper.get().item(icon);
    }

    public static ItemStack getFakeIcon(Block block, BlockAccessor blockAccessor) {
        return block.getCloneItemStack(blockAccessor.getBlockState(), blockAccessor.getHitResult(), (BlockGetter)blockAccessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getPlayer());
    }

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        Block block = blockAccessor.getBlock();
        if (block instanceof TexturedBlockBlock || block instanceof TexturedSlabBlock || block instanceof TexturedWallBlock || block instanceof TexturedStairsBlock) {
            TexturedBlockInfo.addFakeInfo(block, iTooltip, blockAccessor);
        }
    }

    public static void addFakeInfo(Block texturedBlock, ITooltip iTooltip, BlockAccessor blockAccessor) {
        ItemStack fakeStack = TexturedBlockInfo.getFakeIcon(texturedBlock, blockAccessor);
        iTooltip.remove(Identifiers.CORE_OBJECT_NAME);
        iTooltip.remove(Identifiers.CORE_MOD_NAME);
        iTooltip.remove(ModNameRender.RELOCATE);
        MutableComponent fakeNameComponent = fakeStack.m_41786_().m_6881_().m_130940_(ChatFormatting.WHITE);
        String fakeModName = ModIdentification.getModName((ItemStack)fakeStack);
        String fakeModNameFormatted = String.format(((WailaConfig)Jade.CONFIG.get()).getFormatting().getModName(), fakeModName);
        TextElement textElement = new TextElement((Component)fakeNameComponent);
        float f = Minecraft.m_91087_().f_91062_.m_92895_(fakeNameComponent.getString()) + 16;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        iTooltip.add(textElement.size(new Vec2(f, 9.0f)));
        iTooltip.add((Component)Component.m_237113_((String)fakeModNameFormatted));
    }

    public ResourceLocation getUid() {
        return JadeTags.INFO_RENDERER;
    }
}

