/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers.transport;

import ic2.api.util.DirectionList;
import ic2.core.block.transport.item.tubes.ColorFilterTubeTileEntity;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.TextFormatter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ColorFilterTubeInfo
implements IInfoProvider {
    public static final ColorFilterTubeInfo THIS = new ColorFilterTubeInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof ColorFilterTubeTileEntity) {
            ColorFilterTubeTileEntity colorFilterTube = (ColorFilterTubeTileEntity)blockEntity;
            boolean invPrio = colorFilterTube.invPriority;
            helper.text((Component)TextFormatter.GOLD.translate("info.tube.inv.prio", this.status(invPrio)));
            ObjectArrayList filters = new ObjectArrayList();
            for (int i = 0; i < colorFilterTube.colorDirections.length; ++i) {
                ItemStack dyeStack = new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)i)));
                DirectionList directionList = DirectionList.ofNumber((int)colorFilterTube.colorDirections[i]);
                if (directionList.isEmpty()) continue;
                filters.add(new FilterEntry(dyeStack, directionList));
            }
            if (!filters.isEmpty()) {
                helper.paddingY(3);
                Object2ObjectOpenHashMap mappedFilters = new Object2ObjectOpenHashMap();
                for (FilterEntry entry : filters) {
                    Component side2 = JadeHelper.getSides(entry.directions);
                    ((List)mappedFilters.computeIfAbsent((Object)side2, component -> new ArrayList())).add(entry);
                }
                mappedFilters.keySet().forEach(side -> {
                    helper.text((Component)TextFormatter.GOLD.translate("info.tube.filter"));
                    for (FilterEntry entry : (List)mappedFilters.get(side)) {
                        helper.appendItem(entry.stack);
                    }
                    helper.appendText((Component)TextFormatter.WHITE.literal(" \u2192 "));
                    helper.appendText((Component)side);
                });
            }
        }
    }

    public record FilterEntry(ItemStack stack, DirectionList directions) {
    }
}

