/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blockentity;

import ic2.api.network.buffer.NetworkInfo;
import ic2.api.tiles.readers.IFuelStorage;
import ic2.api.util.DirectionList;
import ic2.api.util.ILocation;
import ic2.core.block.base.cache.CapabilityCache;
import ic2.core.block.base.cache.ICache;
import ic2.core.block.base.features.ITickListener;
import ic2.core.block.base.features.IWrenchableTile;
import ic2.core.block.base.misc.comparator.BaseComparator;
import ic2.core.block.base.misc.comparator.ComparatorNames;
import ic2.core.block.base.misc.comparator.types.base.FuelComparator;
import ic2.core.block.base.tiles.BaseInventoryTileEntity;
import ic2.core.inventory.base.ITileGui;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.gtreimagined.tesseract.api.hu.IHeatHandler;
import trinsdar.ic2c_extras.blockentity.IHeatTile;
import trinsdar.ic2c_extras.blockentity.Ic2cExtrasHeatHandler;

public abstract class BlockEntityBaseFuelBox
extends BaseInventoryTileEntity
implements IWrenchableTile,
ITickListener,
ITileGui,
IFuelStorage,
IHeatTile,
ILocation {
    @NetworkInfo
    public int fuel = 0;
    @NetworkInfo
    final Ic2cExtrasHeatHandler heatHandler = new Ic2cExtrasHeatHandler(0, 0, 32, this);
    @NetworkInfo
    public int production;
    ICache<IHeatHandler> heatCache = new CapabilityCache((ILocation)this, DirectionList.ALL, TesseractCaps.HEAT_CAPABILITY);

    public BlockEntityBaseFuelBox(BlockPos pos, BlockState state, int size) {
        super(pos, state, size);
        this.addCaches(new ICache[]{this.heatCache});
        this.addCapability(TesseractCaps.HEAT_CAPABILITY, this.heatHandler);
        this.addGuiFields(new String[]{"heatHandler", "fuel"});
        this.addComparator((BaseComparator)new FuelComparator("fuel", ComparatorNames.FUEL, (IFuelStorage)this));
    }

    public boolean canSetFacing(Direction direction) {
        return direction.m_122434_().m_122479_() && direction != this.getFacing();
    }

    public boolean canRemoveBlock(Player player) {
        return true;
    }

    public double getDropRate(Player player) {
        return 1.0;
    }

    public boolean needsFuel() {
        return this.fuel <= 0 && this.heatHandler.getHeat() + this.production <= this.heatHandler.getHeatCap();
    }

    public boolean needsHeat() {
        return this.fuel > 0 && this.heatHandler.getHeat() + this.production <= this.heatHandler.getHeatCap();
    }

    public abstract boolean gainFuel();

    public boolean gainEnergy() {
        if (this.needsHeat()) {
            this.heatHandler.insertInternal(Math.min(this.production, this.heatHandler.getHeatCap() - this.heatHandler.getHeat()), false);
            this.consumeFuel();
            return true;
        }
        return false;
    }

    protected void consumeFuel() {
        --this.fuel;
    }

    public void onTick() {
        boolean active;
        if (this.needsFuel() && this.gainFuel()) {
            this.updateGuiField("fuel");
        }
        if (active = this.gainEnergy()) {
            this.updateGuiField("fuel");
            this.updateGuiField("heatHandler");
        }
        this.setActive(active);
        this.handleComparators();
    }

    public int getFuel() {
        return this.fuel;
    }

    @Override
    public BlockEntity getOwner() {
        return this;
    }

    @Override
    public IHeatHandler getHeatHandler() {
        return this.heatHandler;
    }

    @Override
    public boolean canInput(Direction direction) {
        return false;
    }

    @Override
    public boolean canOutput(Direction direction) {
        return direction == this.getFacing();
    }
}

