/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blockentity;

import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.network.buffer.NetworkInfo;
import ic2.api.util.DirectionList;
import ic2.api.util.ILocation;
import ic2.core.block.base.cache.CapabilityCache;
import ic2.core.block.base.cache.ICache;
import ic2.core.block.base.features.ITickListener;
import ic2.core.block.base.tiles.BaseElectricTileEntity;
import ic2.core.inventory.base.ITileGui;
import ic2.core.inventory.container.IC2Container;
import ic2.core.inventory.filter.SpecialFilters;
import ic2.core.inventory.filter.special.ElectricItemFilter;
import ic2.core.inventory.handler.AccessRule;
import ic2.core.inventory.handler.InventoryHandler;
import ic2.core.inventory.handler.SlotType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.gtreimagined.tesseract.api.hu.IHeatHandler;
import trinsdar.ic2c_extras.blockentity.IHeatTile;
import trinsdar.ic2c_extras.blockentity.Ic2cExtrasHeatHandler;
import trinsdar.ic2c_extras.container.ContainerElectricHeatGenerator;
import trinsdar.ic2c_extras.init.ModBlocks;

public class BlockEntityElectricHeatGenerator
extends BaseElectricTileEntity
implements IHeatTile,
ITickListener,
ITileGui {
    @NetworkInfo
    final Ic2cExtrasHeatHandler heatHandler = new Ic2cExtrasHeatHandler(0, 0, 32, this){

        @Override
        public int getHeatCap() {
            return 10 * BlockEntityElectricHeatGenerator.this.coilCount;
        }
    };
    ICache<IHeatHandler> heatCache = new CapabilityCache((ILocation)this, DirectionList.ALL, TesseractCaps.HEAT_CAPABILITY);
    int coilCount = 0;

    public BlockEntityElectricHeatGenerator(BlockPos pos, BlockState state) {
        super(pos, state, 11, 32, 10000);
        this.addCaches(new ICache[]{this.heatCache});
        this.setFuelSlot(0);
        this.addCapability(TesseractCaps.HEAT_CAPABILITY, this.heatHandler);
        this.addGuiFields(new String[]{"heatHandler"});
    }

    protected void addSlotInfo(InventoryHandler handler) {
        handler.registerBlockSides(DirectionList.ALL);
        handler.registerBlockAccess(DirectionList.ALL, AccessRule.BOTH);
        handler.registerSlotAccess(AccessRule.BOTH, new int[]{0});
        handler.registerSlotsForSide(DirectionList.UP.invert(), new int[]{0});
        handler.registerInputFilter(SpecialFilters.createChargeFilter(), new int[]{0});
        handler.registerOutputFilter(ElectricItemFilter.NOT_DISCHARGE_FILTER, new int[]{0});
        handler.registerNamedSlot(SlotType.BATTERY, new int[]{0});
    }

    public boolean supportsNotify() {
        return false;
    }

    public BlockEntityType<?> createType() {
        return ModBlocks.ELECTRIC_HEAT_GENERATOR_TYPE;
    }

    @Override
    public BlockEntity getOwner() {
        return this;
    }

    @Override
    public Ic2cExtrasHeatHandler getHeatHandler() {
        return this.heatHandler;
    }

    @Override
    public boolean canInput(Direction direction) {
        return false;
    }

    @Override
    public boolean canOutput(Direction direction) {
        return direction == this.getFacing();
    }

    public void onTick() {
        this.handleChargeSlot(this.maxEnergy);
        if (this.getStoredEU() > 0 && this.heatHandler.getHeat() < this.heatHandler.getHeatCap()) {
            int min = Math.min(Math.min(10, this.getStoredEU()), this.heatHandler.getHeatCap() - this.heatHandler.getHeat());
            this.useEnergy(min);
            this.heatHandler.insertInternal(min, false);
            if (!this.isActive()) {
                this.setActive(true);
            }
            this.updateGuiField("heatHandler");
        } else if (this.isActive()) {
            this.setActive(false);
        }
        this.heatHandler.update(this.isActive());
    }

    public boolean canAcceptEnergy(IEnergyEmitter emitter, Direction side) {
        if (side == this.getFacing()) {
            return false;
        }
        return super.canAcceptEnergy(emitter, side);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        int coilCount = 0;
        for (int i = 1; i < 11; ++i) {
            ItemStack stack1 = this.getStackInSlot(i);
            if (stack1.m_41619_()) continue;
            ++coilCount;
        }
        this.coilCount = coilCount;
    }

    public int getMaxStackSize(int slot) {
        if (slot > 0 && slot < 11) {
            return 1;
        }
        return super.getMaxStackSize(slot);
    }

    public IC2Container createContainer(Player player, InteractionHand interactionHand, Direction direction, int i) {
        return new ContainerElectricHeatGenerator(this, player, i);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.heatHandler.serialize(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.heatHandler.deserialize(compound);
    }
}

