/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.justzoom.JustZoom;
import de.keksuccino.justzoom.util.AbstractOptions;
import de.keksuccino.justzoom.util.gui.StringWidget;
import de.keksuccino.justzoom.util.gui.TooltipHandler;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsScreen
extends Screen {
    @Nullable
    protected Screen parent;

    public OptionsScreen(@Nullable Screen parent) {
        super((Component)Component.m_237115_((String)"justzoom.options"));
        this.parent = parent;
    }

    protected void m_7856_() {
        TooltipHandler.clearAll();
        int centerX = this.f_96543_ / 2;
        int topY = 50;
        int spacing = 25;
        StringWidget titleWidget = (StringWidget)this.m_142416_((GuiEventListener)new StringWidget(this.m_96636_(), this.f_96547_));
        titleWidget.setX(centerX - titleWidget.m_5711_() / 2);
        titleWidget.setY(20);
        int currentY = topY;
        this.addFloatInput(JustZoom.getOptions().baseZoomFactor, currentY, "justzoom.options.base_zoom_modifier");
        this.addFloatInput(JustZoom.getOptions().zoomInPerScroll, currentY += spacing, "justzoom.options.zoom_in_change_modifier_per_scroll");
        this.addFloatInput(JustZoom.getOptions().zoomOutPerScroll, currentY += spacing, "justzoom.options.zoom_out_change_modifier_per_scroll");
        this.m_142416_((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().smoothZoomInOut, currentY += spacing, "justzoom.options.smooth_zoom_in_out"));
        this.m_142416_((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().smoothCameraOnZoom, currentY += spacing, "justzoom.options.smooth_camera_movement_on_zoom"));
        this.m_142416_((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().normalizeMouseSensitivityOnZoom, currentY += spacing, "justzoom.options.normalize_mouse_sensitivity_on_zoom"));
        this.m_142416_((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().allowZoomInMirroredView, currentY += spacing, "justzoom.options.allow_zoom_in_mirrored_view"));
        this.m_142416_((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().hideArmsWhenZooming, currentY += spacing, "justzoom.options.hide_arms_when_zooming"));
        this.m_142416_((GuiEventListener)this.buildToggleButton(JustZoom.getOptions().resetZoomFactorOnStopZooming, currentY += spacing, "justzoom.options.reset_zoom_factor_when_stop_zooming"));
        this.m_142416_((GuiEventListener)this.buildCornerButton(JustZoom.getOptions().optionsButtonCorner, currentY += spacing, "justzoom.options.options_button_corner"));
        this.m_142416_((GuiEventListener)new Button(centerX - 75, this.f_96544_ - 40, 150, 20, CommonComponents.f_130655_, button -> this.m_7379_()));
    }

    protected Button buildToggleButton(@NotNull AbstractOptions.Option<Boolean> option, int y, @NotNull String labelBaseKey) {
        int centerX = this.f_96543_ / 2;
        int buttonWidth = 200;
        MutableComponent enabled = Component.m_237110_((String)labelBaseKey, (Object[])new Object[]{Component.m_237115_((String)"justzoom.options.toggle.enabled").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN))});
        MutableComponent disabled = Component.m_237110_((String)labelBaseKey, (Object[])new Object[]{Component.m_237115_((String)"justzoom.options.toggle.disabled").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED))});
        Button b = new Button(centerX - buttonWidth / 2, y, buttonWidth, 20, (Component)(option.getValue() != false ? enabled : disabled), arg_0 -> OptionsScreen.lambda$buildToggleButton$1(option, (Component)enabled, (Component)disabled, arg_0));
        TooltipHandler.putTooltip(labelBaseKey, TooltipHandler.Tooltip.widget((AbstractWidget)b, labelBaseKey + ".desc"));
        return b;
    }

    protected Button buildCornerButton(@NotNull AbstractOptions.Option<Integer> option, int y, @NotNull String labelBaseKey) {
        int centerX = this.f_96543_ / 2;
        int buttonWidth = 200;
        String[] cornerKeys = new String[]{"justzoom.options.corner.bottom_left", "justzoom.options.corner.bottom_right", "justzoom.options.corner.top_left", "justzoom.options.corner.top_right"};
        int currentValue = option.getValue();
        MutableComponent buttonText = Component.m_237110_((String)labelBaseKey, (Object[])new Object[]{Component.m_237115_((String)cornerKeys[currentValue]).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD))});
        Button b = new Button(centerX - buttonWidth / 2, y, buttonWidth, 20, (Component)buttonText, button -> {
            int newValue = ((Integer)option.getValue() + 1) % 4;
            option.setValue(newValue);
            button.m_93666_((Component)Component.m_237110_((String)labelBaseKey, (Object[])new Object[]{Component.m_237115_((String)cornerKeys[newValue]).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD))}));
        });
        TooltipHandler.putTooltip(labelBaseKey, TooltipHandler.Tooltip.widget((AbstractWidget)b, labelBaseKey + ".desc"));
        return b;
    }

    protected void addFloatInput(@NotNull AbstractOptions.Option<Float> option, int y, @NotNull String labelBaseKey) {
        int centerX = this.f_96543_ / 2;
        StringWidget zoomOutPerScrollText = (StringWidget)this.m_142416_((GuiEventListener)new StringWidget((Component)Component.m_237115_((String)labelBaseKey), this.f_96547_));
        zoomOutPerScrollText.setX(centerX - 5 - zoomOutPerScrollText.m_5711_());
        Objects.requireNonNull(this.f_96547_);
        zoomOutPerScrollText.setY(y + 10 - 9 / 2);
        TooltipHandler.putTooltip(labelBaseKey + "_text", TooltipHandler.Tooltip.widget((AbstractWidget)zoomOutPerScrollText, labelBaseKey + ".desc"));
        EditBox zoomOutPerScroll = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, centerX + 5, y, 150, 20, (Component)Component.m_237115_((String)labelBaseKey)));
        zoomOutPerScroll.m_94144_(String.valueOf(option.getValue()));
        zoomOutPerScroll.m_94151_(s -> {
            if (MathUtils.isFloat((String)s)) {
                option.setValue(Float.valueOf(Float.parseFloat(s)));
            }
        });
        TooltipHandler.putTooltip(labelBaseKey + "_input", TooltipHandler.Tooltip.widget((AbstractWidget)zoomOutPerScroll, labelBaseKey + ".desc"));
    }

    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        this.m_7333_(pose);
        super.m_6305_(pose, mouseX, mouseY, partial);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private static /* synthetic */ void lambda$buildToggleButton$1(AbstractOptions.Option option, Component enabled, Component disabled, Button button) {
        option.setValue((Boolean)option.getValue() == false);
        button.m_93666_((Boolean)option.getValue() != false ? enabled : disabled);
    }
}

