/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.justzoom.util.gui;

import de.keksuccino.justzoom.util.gui.PostRenderTasks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class TooltipHandler {
    private static final Map<String, Tooltip> TOOLTIPS = new HashMap<String, Tooltip>();

    public static void putTooltip(@NotNull String id, @NotNull Tooltip tooltip) {
        TOOLTIPS.put(id, tooltip);
    }

    public static void clearAll() {
        TOOLTIPS.clear();
    }

    public static void tick() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen != null) {
            TOOLTIPS.forEach((id, tooltip) -> {
                if (tooltip.shouldRender.get().booleanValue()) {
                    PostRenderTasks.post((pose, mouseX, mouseY, partial) -> screen.m_96617_(pose, tooltip.tooltip, mouseX, mouseY));
                }
            });
        }
    }

    public static class Tooltip {
        protected Supplier<Boolean> shouldRender;
        protected List<FormattedCharSequence> tooltip;

        @NotNull
        public static Tooltip widget(@NotNull AbstractWidget widget, @NotNull String localizationKey) {
            String s = I18n.m_118938_((String)localizationKey, (Object[])new Object[0]);
            List<String> lines = s.contains("\n") ? List.of(s.split("\n", -1)) : List.of(s);
            ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
            lines.forEach(line -> sequences.addAll(Minecraft.m_91087_().f_91062_.m_92923_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{Component.m_237113_((String)line)}), 150)));
            return new Tooltip(() -> !widget.m_93696_() && widget.m_198029_(), sequences);
        }

        @NotNull
        public static Tooltip widget(@NotNull AbstractWidget widget, Component ... tooltip) {
            ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
            for (Component c : tooltip) {
                sequences.add(c.m_7532_());
            }
            return new Tooltip(() -> !widget.m_93696_() && widget.m_198029_(), sequences);
        }

        @NotNull
        public static Tooltip widget(@NotNull AbstractWidget widget, FormattedCharSequence ... tooltip) {
            return new Tooltip(() -> !widget.m_93696_() && widget.m_198029_(), List.of(tooltip));
        }

        @NotNull
        public static Tooltip generic(@NotNull Supplier<Boolean> shouldRender, @NotNull String localizationKey) {
            String s = I18n.m_118938_((String)localizationKey, (Object[])new Object[0]);
            List<String> lines = s.contains("\n") ? List.of(s.split("\n", -1)) : List.of(s);
            ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
            lines.forEach(line -> sequences.addAll(Minecraft.m_91087_().f_91062_.m_92923_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{Component.m_237113_((String)line)}), 150)));
            return new Tooltip(shouldRender, sequences);
        }

        @NotNull
        public static Tooltip generic(@NotNull Supplier<Boolean> shouldRender, Component ... tooltip) {
            ArrayList<FormattedCharSequence> sequences = new ArrayList<FormattedCharSequence>();
            for (Component c : tooltip) {
                sequences.add(c.m_7532_());
            }
            return new Tooltip(shouldRender, sequences);
        }

        @NotNull
        public static Tooltip generic(@NotNull Supplier<Boolean> shouldRender, FormattedCharSequence ... tooltip) {
            return new Tooltip(shouldRender, List.of(tooltip));
        }

        protected Tooltip(@NotNull Supplier<Boolean> shouldRender, @NotNull List<FormattedCharSequence> tooltip) {
            this.shouldRender = shouldRender;
            this.tooltip = tooltip;
        }
    }
}

